% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildCPTs.R
\name{buildCPTs}
\alias{buildCPTs}
\title{buildCPTs: a function for building conditional probability tables based on pedigree bayesian network.}
\usage{
buildCPTs(
  bn,
  bNodePrunning = TRUE,
  bStateRemoval = TRUE,
  bStateRemoval2 = TRUE,
  lumpingParameter = NULL,
  renorm = "row-wise",
  verbose = FALSE
)
}
\arguments{
\item{bn}{A bayesian network for pedigree object with information of the genotyped members. The ped object must be in Familias format.}

\item{bNodePrunning}{Standard pruning.}

\item{bStateRemoval}{State based pruning.}

\item{bStateRemoval2}{State based pruning (model 2).}

\item{lumpingParameter}{Used for stepwise mutational model.}

\item{renorm}{If "row-wise" is selected, zero probability is assigned for transitions out of range.}

\item{verbose}{Computations output.}
}
\value{
A bayesian network based on pedigree evidence and QP definition.
}
\description{
buildCPTs: a function for building conditional probability tables based on pedigree bayesian network.
}
\examples{
pbn  <- initBN(toyped)
bnet <- buildBN(pbn,QP=3)
bn1  <- buildCPTs(bnet)
}
