% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbroc.paired.methods.R
\name{plot.fbroc.conf.paired}
\alias{plot.fbroc.conf.paired}
\title{Plots function for object of class \code{fbroc.conf.paired}}
\usage{
\method{plot}{fbroc.conf.paired}(x, col = "blue", fill = "royalblue1",
  print.plot = TRUE, ...)
}
\arguments{
\item{x}{Object of class \code{fbroc.conf.paired} to be plotted.}

\item{col}{Color of the curve to be drawn.}

\item{fill}{Fill of the confidence region.}

\item{print.plot}{Logical specifying whether the plot should be printed.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A ggplot, so that the user can customize the plot further.
}
\description{
Given an object of class \code{fbroc.conf.paired} this function plots the contained estimates for 
the confidence region of the \emph{difference} between the two individual ROC curves.
}
\examples{
data(roc.examples)
example <- boot.paired.roc(roc.examples$Cont.Pred, roc.examples$Cont.Pred.Outlier,
                           roc.examples$True.Class, n.boot = 1000)
# Confidence regions for the difference in TPR at specific FPR values                           
tpr.conf <- conf(example, conf.for = "tpr", steps = 50)
plot(tpr.conf)
# Confidence regions for the difference in FPR at specific TPR values 
fpr.conf <- conf(example, conf.for = "fpr", steps = 50)
plot(fpr.conf) 
}
\seealso{
\code{\link{conf.fbroc.paired.roc}}
}

