% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcm.infer.R
\name{fcm.infer}
\alias{fcm.infer}
\title{Inference of Fuzzy Cognitive Maps (FCMs)}
\usage{
fcm.infer(activation_vec, weight_mat, iter = 20, infer = "k",
  transform = "s", lambda = 1, e = 0.001)
}
\arguments{
\item{activation_vec}{1 x m data frame which contains the initial concept values. A concept is turned on or activated by making its vector element 1 or 0 or in [0, 1].}

\item{weight_mat}{m x m data frame which stores the weights assigned to the pairs of concepts. The weights are usually normalized to the interval [0,1 ] or [-1, +1].}

\item{iter}{The required number of iterations in order to reach the FCM convergence. Defaults to 20.}

\item{infer}{Select an Inference Rule ('k' Kosko, 'mk' modified Kosko, 'r' Rescale,'kc' Kosko-clamped, 'mkc' modified Kosko-clamped or 'rc' Rescale-clamped). Default value is set to 'k'}

\item{transform}{Contains the Transformation functions ('b' Bivalent,  'tr' Trivalent,  's' Sigmoid or 't' Hyperbolic tangent). The transformation function is used to reduce unbounded weighted sum to a certain range, which hinders quantitative analysis, but allows for qualitative comparisons between concepts. Default value is set equal to 's'.}

\item{lambda}{A parameter that determines the steepness of the sigmoid and hyperbolic tangent function at values around 0. Different lambda value may perform more appropriate for different problems.}

\item{e}{Epsilon (e) is a residual, describing the minimum error difference among the subsequent concepts. Its value depends on the application type. Defaults to 0.001.}
}
\value{
Returns iter x m data frame which contains the concepts' values of each iteration after the the transformation function.
}
\description{
Estimates the Inference of a Fuzzy Cognitive Map. Moreover, the 'fcm' package provides a selection of 6 different inference rules and 4 threshold functions in order to obtain the FCM inference. FCM (Kosko, 1986) is proven to be capable of causal inference and is applicable to complex decision problems where numerous interlinked dependent variables influence one another.
}
\examples{
\dontrun{
# Example for the FCM inference with 8 nodes


### Input data

# Create the activation vector
act.vec <- data.frame(1, 1, 0, 0, 0, 0, 0, 0)
# Change the column names
colnames(act.vec) <- c("C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8")

C1 = c(0.0, 0.0, 0.6, 0.9, 0.0, 0.0, 0.0, 0.8)
C2 = c(0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.2, 0.5)
C3 = c(0.0, 0.7, 0.0, 0.0, 0.9, 0.0, 0.4, 0.1)
C4 = c(0.4, 0.0, 0.0, 0.0, 0.0, 0.9, 0.0, 0.0)
C5 = c(0.0, 0.0, 0.0, 0.0, 0.0, -0.9, 0.0, 0.3)
C6 = c(-0.3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
C7 = c(0.0, 0.0, 0.0, 0.0, 0.0, 0.8, 0.4, 0.9)
C8 = c(0.1, 0.0, 0.0, 0.0, 0.0, 0.1, 0.6, 0.0)

# Create the weight matrix
w.mat <- matrix(c(C1, C2, C3, C4, C5, C6, C7, C8),
                nrow = 8, ncol = 8, byrow = TRUE)
colnames(w.mat) <- c("C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8")
w.mat <- as.data.frame(w.mat)



### Select the arguments for the fcm.infer function

output <- fcm.infer(act.vec, w.mat, 50, "r", "s")
View(output$values)   # View the concept values for each iteration


### Visualize the concepts' values for each state

library (reshape2)
library (ggplot2)
# create a numeric vector named "iterations"
iterations <- as.numeric(rownames(output$values))
# add "iterations" in the "output$values" dataframe
df <- data.frame(iterations, output$values)
#transform df into long formats
df2 <- melt(df, id="iterations")
ggplot(data=df2,
       aes(x=iterations, y=value, group=variable, colour=variable)) +
       theme_bw() + geom_line(size=0.7) + geom_point(size = 2)
}
## End(Not run)
\dontshow{
# Example 1 for the FCM inference with 7 nodes


### Input data
library(fcm)
# Create the activation vector
act.vec <- data.frame(1, 1, 0, 0, 0, 0, 0)
# Change the column names
colnames(act.vec) <- c("C1", "C2", "C3", "C4", "C5", "C6", "C7")

C1 = c(0.0, 0.0, 0.6, 0.9, 0.0, 0.0, 0.0)
C2 = c(0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.2)
C3 = c(0.0, 0.7, 0.0, 0.0, 0.9, 0.0, 0.4)
C4 = c(0.4, 0.0, 0.0, 0.0, 0.0, 0.9, 0.0)
C5 = c(0.0, 0.0, 0.0, 0.0, 0.0, -0.9, 0.0)
C6 = c(-0.3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
C7 = c(0.0, 0.0, 0.0, 0.0, 0.0, 0.8, 0.4)

# Create the weight matrix
w.mat <- matrix(c(C1, C2, C3, C4, C5, C6, C7),
                nrow = 7, ncol = 7, byrow = TRUE)
colnames(w.mat) <- c("C1", "C2", "C3", "C4", "C5", "C6", "C7")
w.mat <- as.data.frame(w.mat)



### Select the arguments for the fcm.infer function

output <- fcm.infer(act.vec, w.mat, 25, "rc", "s", , 0.0001)


### Visualize the concepts' values for each state

library (reshape2)
library (ggplot2)
# create a numeric vector named "iterations"
iterations <- as.numeric(rownames(output$values))
# add "iterations" in the "output$values" dataframe
df <- data.frame(iterations, output$values)
#transform df into long formats
df2 <- melt(df, id="iterations")
ggplot(data=df2,
       aes(x=iterations, y=value, group=variable, colour=variable)) +
       theme_bw() + geom_line(size=0.7) + geom_point(size = 3)
}

\dontshow{
# Example 2 for the FCM inference with 5 nodes


### Input data
library(fcm)
# Create the activation vector
act.vec2 <- data.frame(1, 0, 0, 0, 0)
# Change the column names
colnames(act.vec2) <- c("C1", "C2", "C3", "C4", "C5")

C1 = c(0.0, 0.0, 0.6, 0.9, 0.0)
C2 = c(0.3, 0.0, 0.0, 0.7, 0.0)
C3 = c(0.0, 0.7, 0.0, 0.0, 0.9)
C4 = c(0.0, 0.6, 0.0, 0.0, 0.0)
C5 = c(0.2, 0.4, 0.0, 0.0, 0.0)

# Create the weight matrix
w.mat2 <- matrix(c(C1, C2, C3, C4, C5),
                nrow = 5, ncol = 5, byrow = TRUE)
colnames(w.mat2) <- c("C1", "C2", "C3", "C4", "C5")
w.mat2 <- as.data.frame(w.mat2)


### Select the arguments for the fcm.infer function
output2 <- fcm.infer(act.vec2, w.mat2, 10, "k", "tr")


### Visualize the concepts' values for each state

library (reshape2)
library (ggplot2)
# create a numeric vector named "iterations"
iterations <- as.numeric(rownames(output2$values))
# add "iterations" in the "output2$values" dataframe
df2 <- data.frame(iterations, output2$values)
#transform df into long formats
df2b <- melt(df2, id="iterations")
ggplot(data=df2b,
       aes(x=iterations, y=value, group=variable, colour=variable)) +
       theme_bw() + geom_line(size=0.7) + geom_point(size = 3)
}
}
\references{
B. Kosko, "Fuzzy cognitive maps", International Journal of Man-Machine Studies 24, p.p. 65-75, 1986.

C.D. Stylios, P.P. Groumpos, "A Soft Computing Approach for Modelling the Supervisor of Manufacturing Systems", Intelligent and Robotic Systems, vol. 26, p.p. 389-403, 1999.

E.I. Papageorgiou, "A new methodology for Decisions in Medical Informatics using fuzzy cognitive maps based on fuzzy rule-extraction techniques", Applied Soft Computing, vol. 11, Issue 1, p.p. 500-513, 2011.

E.I. Papageorgiou, "Fuzzy Cognitive Maps for Applied Sciences and Engineering From Fundamentals to Extensions and Learning Algorithms", Intelligent Systems Reference Library, Vol 54, 2014.
}
\author{
Zoumpoulia Dikopoulou <dikopoulia@gmail.com>, <zoumpolia.dikopoulou@uhasselt.be>

Elpiniki Papageorgiou <epapageorgiou@teiste.gr>, <e.i.papageorgiou75@gmail.com>
}
