% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{fct_apply}
\alias{fct_apply}
\title{Apply a Function to Factor Levels}
\usage{
fct_apply(factor_vec, apply_func)
}
\arguments{
\item{factor_vec}{A factor vector to transform.}

\item{apply_func}{A function to apply to each level.}
}
\value{
A factor vector with transformed levels.
}
\description{
Transforms factor levels by applying a function to each level.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', 'banana', 'cherry'))

# Append '_fruit' to each level
fct_apply(factor_vec, function(x) paste0(x, '_fruit'))
}
\author{
Kai Guo
}
