% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_group_warp_bayes.R
\name{function_group_warp_bayes}
\alias{function_group_warp_bayes}
\title{Bayesian Group Warping}
\usage{
function_group_warp_bayes(
  f,
  time,
  iter = 50000,
  powera = 1,
  times = 5,
  tau = ceiling(times * 0.04),
  gp = seq(dim(f)[2]),
  showplot = TRUE
)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{time}{sample points of functions}

\item{iter}{number of iterations (default = 150000)}

\item{powera}{Dirchelet prior parameter (default 1)}

\item{times}{factor of length of subsample points to look at (default = 5)}

\item{tau}{standard deviation of Normal prior for increment (default ceil(times*.4))}

\item{gp}{number of colors in plots (default seq(dim(f)[2]))}

\item{showplot}{shows plots of functions (default = T)}
}
\value{
Returns a list containing \item{f0}{original functions}
\item{f_q}{f aligned quotient space}
\item{gam_q}{warping functions quotient space}
\item{f_a}{f aligned ambient space}
\item{gam_a}{warping ambient space}
\item{qmn}{mean srsf}
}
\description{
This function aligns a set of functions using Bayesian SRSF framework
}
\examples{
\dontrun{
data("simu_data")
out = function_group_warp_bayes(simu_data$f, simu_data$time)
}
}
\references{
Cheng, W., Dryden, I. L., and Huang, X. (2016). Bayesian
registration of functions and curves. Bayesian Analysis, 11(2), 447-475.
}
\concept{srsf alignment}
\keyword{bayesian}
