% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{evaluation.recall}
\alias{evaluation.recall}
\title{Recall of classification predictions}
\usage{
evaluation.recall(predictions, gt, positive = levels(gt)[1], ...)
}
\arguments{
\item{predictions}{The predictions of a classification model (\code{factor} or \code{vector}).}

\item{gt}{The ground truth (\code{factor} or \code{vector}).}

\item{positive}{The label of the positive class.}

\item{...}{Other parameters.}
}
\value{
The evaluation of the predictions (numeric value).
}
\description{
Evaluation predictions of a classification model according to recall. Works only for two classes problems.
}
\examples{
require (datasets)
data (iris)
d = iris
levels (d [, 5]) = c ("+", "+", "-") # Building a two classes dataset
d = splitdata (d, 5)
model.nb = NB (d$train.x, d$train.y)
pred.nb = predict (model.nb, d$test.x)
evaluation.recall (pred.nb, d$test.y)
}
\seealso{
\code{\link{evaluation.accuracy}}, \code{\link{evaluation.fmeasure}}, \code{\link{evaluation.fowlkesmallows}}, \code{\link{evaluation.goodness}}, \code{\link{evaluation.jaccard}}, \code{\link{evaluation.kappa}},
\code{\link{evaluation.precision}}, \code{\link{evaluation}}
}
