% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{randomforest}
\alias{randomforest}
\title{Random Forest.
Trains a random forest on the training dataset and uses it to predict the classification of the test dataset. The resulting accuracy, sensitivity and specificity are returned, as well as a summary of the importance of features in the dataset.}
\usage{
randomforest(data_train, data_test, numoftrees = 10, includeplot = FALSE)
}
\arguments{
\item{data_train}{Training set: dataframe containing classification column and all other columns features. This is the dataset on which the decision tree model is trained.}

\item{data_test}{Test set: dataframe containing classification column and all other columns features. This is the dataset on which the decision tree model in tested.}

\item{numoftrees}{Number of trees used in the random forest (default:10)}

\item{includeplot}{Show performance scatter plot (default:FALSE)}
}
\value{
List containing performance percentages, accessed using training (training accuracy), test (test accuracy), trainsensitivity, testsensitivity, trainspecificity, testspecificity. Also accessed using importance is the vector of Mean Decrease in Gini Index. This can be used to find the features which contribute most to classification.
}
\description{
Random Forest.
Trains a random forest on the training dataset and uses it to predict the classification of the test dataset. The resulting accuracy, sensitivity and specificity are returned, as well as a summary of the importance of features in the dataset.
}
\examples{
data_train = data.frame(
      classification=as.factor(c(1,1,0,0,1,1,0,0,1,1)),
      A=c(1,1,1,0,0,0,1,1,1,0),
      B=c(0,1,1,0,1,1,0,1,1,0),
      C=c(0,0,1,0,0,1,0,0,1,0))
data_test = data.frame(
      classification=as.factor(c(1,1,0,0,1,1,1,0)),
      A=c(0,0,0,1,0,0,0,1),
      B=c(1,1,1,0,0,1,1,1),
      C=c(0,0,1,1,0,0,1,1))
randomforest(data_train,data_test,numoftrees=5)
}
\keyword{classification}
\keyword{rf}
