% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cfr_text}
\alias{cfr_text}
\title{Extract the Text for a Given Year, Title, Chapter, and Part}
\usage{
cfr_text(year, title_number, chapter, part, token = "words",
  return_tidytext = TRUE, verbose = FALSE, ...)
}
\arguments{
\item{year}{numeric between 1996 and 2017.}

\item{title_number}{numeric between 1 and 50.}

\item{chapter}{numeric or roman numeral.}

\item{part}{numeric.}

\item{token}{character. Unit for tokenizing. Currently}

\item{return_tidytext}{logical. TRUE = tidytext, FALSE = raw data}

\item{verbose}{logical. Will return "helpful" messages regarding the status of the URL.}

\item{...}{Extra arguments passed on to tokenizers, such as n and k for "ngrams" and "skip_ngrams"}
}
\value{
a tibble with year, title_number, chapter, part, and text nested by subpart
}
\description{
\code{cfr_text} returns a tibble of CFR text
}
\details{
cfr_text

This function is the main function of the \code{fedregs} package. It takes the title, chapter, part, and year and returns a tibble of raw text (\code{return_tidytext = FALSE}) or \href{https://www.tidytextmining.com/tidytext.html}{tidytext} text (\code{return_tidytext = TRUE}). N.b., it has not been extensively tested on titles and chapters other than Title 50 chapter VI and part 648.
}
\examples{
\donttest{regs <- cfr_text(year = 2017,
title_number = 50,
chapter = 6,
part = 648,
return_tidytext = TRUE,
token = "words",
verbose = TRUE)
head(regs)}

}
