% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetwfe.R
\name{genCoefs}
\alias{genCoefs}
\title{Generate Coefficient Vector for Data Generation}
\usage{
genCoefs(R, T, d, density, eff_size, seed = NULL)
}
\arguments{
\item{R}{Integer. The number of treated cohorts (treatment is assumed to start in periods 2 to
\code{R + 1}).}

\item{T}{Integer. The total number of time periods.}

\item{d}{Integer. The number of time-invariant covariates. If \code{d > 0}, additional terms
corresponding to covariate main effects and interactions are included in \code{beta}.}

\item{density}{Numeric in (0,1). The probability that any given entry in the initial sparse
coefficient vector \code{theta} is nonzero.}

\item{eff_size}{Numeric. The magnitude used to scale nonzero entries in \code{theta}. Each
nonzero entry is set to \code{eff_size} or \code{-eff_size} (with a 60 percent chance for a
positive value).}

\item{seed}{(Optional) Integer. Seed for reproducibility.}
}
\value{
An object of class \code{"FETWFE_coefs"}, which is a list containing:
\describe{
\item{beta}{A numeric vector representing the full coefficient vector after the inverse fusion
transform.}
\item{R}{The provided number of treated cohorts.}
\item{T}{The provided number of time periods.}
\item{d}{The provided number of covariates.}
\item{seed}{The provided seed.}
}
}
\description{
This function generates a coefficient vector \code{beta} for simulation studies of the fused
extended two-way fixed effects estimator. It returns an S3 object of class
\code{"FETWFE_coefs"} containing \code{beta} along with simulation parameters \code{R},
\code{T}, and \code{d}. See the simulation studies section of Faletto (2025) for details.
}
\details{
The length of \code{beta} is given by
\deqn{p = R + (T - 1) + d + dR + d(T - 1) + \mathit{num\_treats} + (\mathit{num\_treats} \times d)}{p = R + (T - 1) + d + dR + d(T - 1) + num_treats + (num_treats * d)},
where the number of treatment parameters is defined as
\deqn{\mathit{num\_treats} = T \times R - \frac{R(R+1)}{2}}{num_treats = T * R - R(R+1)/2}.

The function operates in two steps:
\enumerate{
\item It first creates a sparse vector \code{theta} of length \eqn{p}, with nonzero entries
occurring with probability \code{density}. Nonzero entries are set to \code{eff_size} or
\code{-eff_size} (with a 60\\% chance for a positive value).
\item The full coefficient vector \code{beta} is then computed by applying an inverse fusion
transform to \code{theta} using internal routines (e.g.,
\code{genBackwardsInvFusionTransformMat()} and \code{genInvTwoWayFusionTransformMat()}).
}
}
\examples{
\dontrun{
  # Generate coefficients
  coefs <- genCoefs(R = 5, T = 30, d = 12, density = 0.1, eff_size = 2, seed = 123)

  # Simulate data using the coefficients
  sim_data <- simulateData(coefs, N = 120, sig_eps_sq = 5, sig_eps_c_sq = 5)
}

}
\references{
Faletto, G (2025). Fused Extended Two-Way Fixed Effects for
Difference-in-Differences with Staggered Adoptions.
\emph{arXiv preprint arXiv:2312.05985}.
\url{https://arxiv.org/abs/2312.05985}.
}
