% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_information.R
\name{double_decay}
\alias{double_decay}
\alias{double_decay.default}
\alias{double_decay.numeric}
\alias{double_decay.matrix}
\alias{double_decay.ts}
\alias{double_decay.xts}
\alias{double_decay.tbl}
\alias{double_decay.data.frame}
\title{Flexible Probabilities using Partial Information}
\usage{
double_decay(x, slow, fast)

\method{double_decay}{default}(x, slow, fast)

\method{double_decay}{numeric}(x, slow, fast)

\method{double_decay}{matrix}(x, slow, fast)

\method{double_decay}{ts}(x, slow, fast)

\method{double_decay}{xts}(x, slow, fast)

\method{double_decay}{tbl}(x, slow, fast)

\method{double_decay}{data.frame}(x, slow, fast)
}
\arguments{
\item{x}{An univariate or a multivariate distribution.}

\item{slow}{A number with the long half-life (slow decay) for the correlation
matrix.}

\item{fast}{A number with the short-life (high decay) for the volatility.}
}
\value{
A numerical vector of class \code{ffp} with the new
probabilities distribution.
}
\description{
This function uses entropy-pooling to match different decay-factors on the
covariance matrix.
}
\examples{
\donttest{
  library(ggplot2)

  slow <- 0.0055
  fast <- 0.0166
  ret <- diff(log(EuStockMarkets))

  dd <- double_decay(ret, slow, fast)
  dd

  autoplot(dd) +
    scale_color_viridis_c()
}
}
\references{
De Santis, G., R. Litterman, A. Vesval, and K. Winkelmann, 2003,
Covariance matrix estimation, Modern investment management: an equilibrium
approach, Wiley.
}
\seealso{
\code{\link{kernel_entropy}} \code{\link{half_life}}
}
