% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_starterpositions.R,
%   R/flea_starterpositions.R, R/mfl_starterpositions.R,
%   R/sleeper_starterpositions.R
\name{ff_starter_positions}
\alias{ff_starter_positions}
\alias{ff_starter_positions.espn_conn}
\alias{ff_starter_positions.flea_conn}
\alias{ff_starter_positions.mfl_conn}
\alias{ff_starter_positions.sleeper_conn}
\title{Get Starting Lineup Settings}
\usage{
ff_starter_positions(conn, ...)

\method{ff_starter_positions}{espn_conn}(conn, ...)

\method{ff_starter_positions}{flea_conn}(conn, ...)

\method{ff_starter_positions}{mfl_conn}(conn, ...)

\method{ff_starter_positions}{sleeper_conn}(conn, ...)
}
\arguments{
\item{conn}{the list object created by \code{ff_connect()}}

\item{...}{other arguments (currently unused)}
}
\value{
A tidy dataframe of positional lineup rules, one row per position with minimum and maximum starters as well as total starter calculations.
}
\description{
This function returns a tidy dataframe with positional lineup rules.
}
\section{Methods (by class)}{
\itemize{
\item \code{espn_conn}: ESPN: returns min/max starters for each main player position

\item \code{flea_conn}: Fleaflicker: returns minimum and maximum starters for each player position.

\item \code{mfl_conn}: MFL: returns minimum and maximum starters for each player position.

\item \code{sleeper_conn}: Sleeper: returns minimum and maximum starters for each player position.
}}

\examples{
\donttest{
conn <- espn_connect(season = 2020, league_id = 1178049)
ff_starter_positions(conn)
}

\donttest{
conn <- fleaflicker_connect(season = 2020, league_id = 206154)
ff_starter_positions(conn)
}

\donttest{
dlfidp_conn <- mfl_connect(2020, league_id = 54040)
ff_starter_positions(conn = dlfidp_conn)
}

\donttest{
jml_conn <- sleeper_connect(league_id = "652718526494253056", season = 2021)
jml_starters <- ff_starter_positions(jml_conn)
}

}
