% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfl_connect.R
\name{mfl_connect}
\alias{mfl_connect}
\title{Connect to MFL League}
\usage{
mfl_connect(
  season = NULL,
  league_id = NULL,
  APIKEY = NULL,
  user_name = NULL,
  password = NULL,
  user_agent = NULL,
  rate_limit = TRUE,
  rate_limit_number = NULL,
  rate_limit_seconds = NULL,
  ...
)
}
\arguments{
\item{season}{Season to access on MFL - if missing, will guess based on system date (current year if March or later, otherwise previous year)}

\item{league_id}{league_id Numeric ID parameter for each league, typically found in the URL}

\item{APIKEY}{APIKEY - optional - allows access to private leagues. Key is unique for each league and accessible from Developer's API page (currently assuming one league at a time)}

\item{user_name}{MFL user_name - optional - when supplied in conjunction with a password, will attempt to retrieve authentication token}

\item{password}{MFL password - optional - when supplied in conjunction with user_name, will attempt to retrieve authentication token}

\item{user_agent}{A string representing the user agent to be used to identify calls - may find improved rate_limits if verified token}

\item{rate_limit}{TRUE by default, pass FALSE to turn off rate limiting}

\item{rate_limit_number}{number of calls per \code{rate_limit_seconds}, suggested is 60 calls per 60 seconds}

\item{rate_limit_seconds}{number of seconds as denominator for rate_limit}

\item{...}{silently swallows up unused arguments}
}
\value{
a connection object to be used with \verb{ff_*} functions
}
\description{
This function creates a connection object which stores parameters and gets a login-cookie if available
}
\examples{
\donttest{
mfl_connect(season = 2020, league_id = 54040)
mfl_connect(season = 2019, league_id = 54040, rate_limit = FALSE)
}
}
