% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_optimise.R
\name{ffs_optimise_lineups}
\alias{ffs_optimise_lineups}
\alias{ffs_optimize_lineups}
\title{Optimise Lineups}
\usage{
ffs_optimise_lineups(
  roster_scores,
  lineup_constraints,
  lineup_efficiency_mean = 0.775,
  lineup_efficiency_sd = 0.05,
  best_ball = FALSE,
  parallel = FALSE
)

ffs_optimize_lineups(
  roster_scores,
  lineup_constraints,
  lineup_efficiency_mean = 0.775,
  lineup_efficiency_sd = 0.05,
  best_ball = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{roster_scores}{a dataframe as generated by \code{ffs_score_rosters()} - should contain columns like: projected_score, pos, and player_id}

\item{lineup_constraints}{a dataframe as generated by \code{ffscrapr::ff_starter_positions()} - should contain columns pos, min, max, and offense_starters}

\item{lineup_efficiency_mean}{the average lineup efficiency to use, defaults to 0.775}

\item{lineup_efficiency_sd}{the standard deviation of lineup efficiency, defaults to 0.05}

\item{best_ball}{a logical: FALSE will apply a lineup efficiency factor and TRUE uses optimal scores as actual scores, default = FALSE}

\item{parallel}{a logical: TRUE will run the optimization in parallel, requires the furrr and future packages as well as setting \code{future::plan()} in advance/externally. Default FALSE.}
}
\value{
a dataframe of what each team scored for each week
}
\description{
Calculates optimal lineups for all franchises in the dataframe based on a table of lineup constraints.
}
\details{
Lineup efficiency is the percentage of optimal/best-ball score that is used as the actual score - by default, the lineup efficiency for a team in non-best-ball settings is normally distributed around a mean of 77.5\% and a standard deviation of 5\%.
}
\examples{
\donttest{
# cached examples
roster_scores <- .ffs_cache("roster_scores.rds")
lineup_constraints <- .ffs_cache("mfl_lineup_constraints.rds")

ffs_optimise_lineups(roster_scores, lineup_constraints)

}

}
\seealso{
\code{vignette("Custom Simulations")} for example usage
}
