% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\name{fhir_crack}
\alias{fhir_crack}
\title{Flatten list of FHIR bundles}
\usage{
fhir_crack(
  bundles,
  design,
  sep = " -+- ",
  remove_empty_columns = FALSE,
  add_indices = FALSE,
  brackets = c("<", ">"),
  verbose = 2
)
}
\arguments{
\item{bundles}{A FHIR search result as returned by \code{\link{fhir_search}}.}

\item{design}{A named list specifying which data frame should contain which entries of the bundle.
The names correspond to the names of the resulting data frames.

Each element of design is a list of length 1 or 2, where the first element is a XPath expression to locate the entry in a
FHIR bundle page. There are 3 options for the second element of that list:

- There is no second element: all attributes of the resource are extracted

- The second element is a string containing a XPath expression to all the values that should be extracted. "./@value" e.g. would extract all
  values on the root level.

- The second element is a named list where the elements are XPath expressions indicating the specific position of values to extract,
 where the names of the list elements are the column names of the resulting data frame.

For a more detailed explanation see the package vignette.}

\item{sep}{A string to separate pasted multiple entries.}

\item{remove_empty_columns}{Logical scalar. Remove empty columns?}

\item{add_indices}{A Logical scalar.}

\item{brackets}{A character vector of length two defining the Brackets surrounding the indices. e.g. c( "<", ">")}

\item{verbose}{An Integer Scalar.  If 0, nothings is printed, if 1, only finishing message is printed, if > 1,
extraction progress will be printed. Defaults to 2.
#' @return A list of data frames as specified by \code{design}.}
}
\value{
A list of data frames as specified by \code{design}
}
\description{
Converts all FHIR bundles (the result of \code{\link{fhir_search}}) to a list of data frames.
}
\examples{
#unserialize example bundle
bundles <- fhir_unserialize(medication_bundles)

#define attributes to extract
df_design <- list(

 #define specifically which elements to extract
	MedicationStatement = list(

		".//MedicationStatement",

		list(
			MS.ID              = "id/@value",
			STATUS.TEXT        = "text/status/@value",
			STATUS             = "status/@value",
			MEDICATION.SYSTEM  = "medicationCodeableConcept/coding/system/@value",
			MEDICATION.CODE    = "medicationCodeableConcept/coding/code/@value",
			MEDICATION.DISPLAY = "medicationCodeableConcept/coding/display/@value",
			DOSAGE             = "dosage/text/@value",
			PATIENT            = "subject/reference/@value",
			LAST.UPDATE        = "meta/lastUpdated/@value"
		)
	),

 #extract all values
	Patients = list(

		".//Patient"
	)
)

#convert fhir to data frames
list_of_tables <- fhir_crack(bundles, df_design)

#check results
head(list_of_tables$MedicationStatement)
head(list_of_tables$Patients)

}
