% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classModel.R
\name{classModel}
\alias{classModel}
\title{classModel}
\usage{
classModel(x, y, z, mode = "classification", ...)
}
\arguments{
\item{x}{Object of class \emph{data.frame}.}

\item{y}{A vector of class \emph{character} or \emph{numeric}.}

\item{z}{A vector of class \emph{character} or \emph{numeric}.}

\item{mode}{One of "classification" or "regression".}

\item{...}{Arguments passed to \link[caret]{train}.}
}
\value{
A two element numeric \emph{vector}.
}
\description{
Derives a predictive model for
}
\details{
{Uses \link[caret]{train} to derive a predictive model based on \emph{x} - which contains the predictors - and \emph{y} - which
contains information on the target classes (if \emph{mode} is "classification") or values (if \emph{mode} is "regression"). This method
iterates through all samples making sure that all contribute for the final accuracy. To specify how the samples should be split, the user
should provide the sample-wise identifiers through \emph{z}. For each unique value in \emph{z}, the function keeps it for validation and
the remaining samples for training. This process is repeated for all sample groups and a final accuracy is estimated from the overall set
of results. If \emph{mode} is "classification", the function will estimate the overall accuracy for each unique value in \emph{y}. If
"regression" is set, the output will be an the coefficient of determination. The classification algorithm and additional commands can be 
set through \emph{...} using inputs of the \link[caret]{train} function. Apart from the accuracy assessment, the function stores the 
performance for each sample.
If \emph{mode} is "classification", the function will return a logical vector reporting on the correctly assigned classes. If \emph{mode}
is "regression", the function will report on the percent deviation between the original value and it's predicted value. The final output
of the function is a list consisting of:
\itemize{
 \item{\emph{sample.validation} - Accuracy assessment of each sample.}
 \item{\emph{overall.validation} - Finally accuracy value for each class (if "classification").}
 \item{\emph{r2} - Correlation between \emph{y} and the predicted values (if "regression")}}}
}
\examples{
{

require(raster)

# read raster data
r <- brick(system.file("extdata", "ndvi.tif", package="fieldRS"))

# read field data
data(fieldData)
fieldData <- fieldData[c(1:3, 10),]

# extract values for polygon centroid
c <- spCentroid(fieldData)
ev <- as.data.frame(extract(r, c))

cm <- classModel(ev, fieldData$crop, as.character(1:length(fieldData)), method="rf")

}
}
\seealso{
\code{\link{raster2sample}} \code{\link{poly2sample}} \code{\link{ccLabel}}
}
