% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.tests.R
\name{univariate.tests}
\alias{univariate.tests}
\title{Extract p values for a data frame}
\usage{
univariate.tests(dataframe, exclude.cols = NULL, group, parametric = T, ...)
}
\arguments{
\item{dataframe}{a data frame containing both the variables and the grouping variable}

\item{exclude.cols}{a vector indicating (either numeric or character) which columns should not have a significance test}

\item{group}{a string with the name of the grouping variable}

\item{parametric}{Should parametric tests be used? Defaults to TRUE.}

\item{...}{other arguments passed to t.test or wilcox.test}
}
\value{
a vector of p values
}
\description{
Given a dataframe, this function predicts the specified categorical variable using each column in the dataset, one at a time.
The function will automatically select whether to do a chi-square test, a t-test, or an ANOVA. See details.
}
\details{
Extract the p value from a univariate significance test

\code{univariate.tests} will look at each column in the dataframe, then perform a t-test (or wilcoxen.test if parametric=TRUE), ANOVA 
(or kruskal.test if parametric=TRUE), or chi-square test where
the grouping variable serves as the independent variable. The computer will chose a chi-square test of one of the following three conditions is
met: (1) the variable is a factor, (2) the variable is a character variable, or (3) the variable has less than four unique values. An ANOVA (or Kruskall) will be
used if the number of levels of the grouping variable is greater than two. In all other cases, a t-test (or wilcoxen) will be used.
}
\examples{
k = data.frame(cbind(ID=1:100,
			A = rnorm(100),
			B = rnorm(100),
			C = rnorm(100),
			Group = rep(1:2, times=50)))
univariate.tests(dataframe = k, exclude.cols=1, group="Group")
}
\author{
Dustin Fife
}

