% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-nice-nums.R
\name{nice_nums}
\alias{nice_nums}
\title{Make string numbers comply with alphabetical order}
\usage{
nice_nums(strings)
}
\arguments{
\item{strings}{A vector of strings.}
}
\description{
If strings are numbered, their numbers may not \emph{comply} with
alphabetical order, i.e. "abc2" comes after "abc10" in alphabetical order. We
might (for whatever reason) wish to change them such that they come in the
order \emph{that we would like}. This function alters the strings such that
they comply with alphabetical order, so here "abc2" would be renamed to
"abc02". It works on file names with more than one number in them e.g.
"abc01def3" (a string with 2 numbers). All the file names that it works on
must have the same number of numbers, and the non-number bits must be the
same.
}
\examples{
strings <- paste0("abc", 1:12)
strings
nice_nums(strings)

nice_nums(c("abc9def55", "abc10def7"))
nice_nums(c("01abc9def55", "5abc10def777", "99abc4def4"))
nice_nums(1:10)

\dontrun{
nice_nums(c("abc9def55", "abc10xyz7"))}
}
