% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_nuclear.R
\name{fill.nuclear}
\alias{fill.nuclear}
\title{Low-Rank Completion with Nuclear Norm Optimization}
\usage{
fill.nuclear(A, tolerance = 0.001)
}
\arguments{
\item{A}{an \eqn{(n\times p)} partially observed matrix.}

\item{tolerance}{level of tolerance for entrywise equality condition.}
}
\value{
a named list containing \describe{
\item{X}{an \eqn{(n\times p)} matrix after completion.}
\item{norm}{solution of the minimization problem; approximate rank.}
\item{cvxr.status}{``optimal'' denotes the problem was solved. See \code{\link[CVXR]{psolve}} for more details on solvability.}
\item{cvxr.niters}{the number of iterations taken.}
\item{cvxr.solver}{type of solver used by \pkg{CVXR}.}
}
}
\description{
In many circumstances, it is natural to assume that there exists an underlying
low-rank structure. The assumption of \emph{low-rank} property leads to an optimization problem
for matrix completion problem,
\deqn{\mathrm{minimize}\quad rank(X)}
\deqn{\mathrm{s.t}~~ X_{ij}=A_{ij} ~~\mathrm{for}~~ A_{ij} \in E}
where \eqn{A_{ij}\in E} means the \eqn{(i,j)}-th entry of data matrix \eqn{A} is not missing. The objective
function can be further relaxed by nuclear norm
\deqn{\|X\|_* = \sum \sigma_i(X)}
where \eqn{\sigma_i (X)} is \eqn{i}-th singular value of the matrix \eqn{X}. Note that
for modeling purpose, we adopted closeness parameter \code{tolerance} for equality constraint.
\pkg{CVXR} package was used in implementation. Computational efficiency may not be guaranteed for large data matrix.
}
\examples{
## load image data of 'lena64'
data(lena64)

## transform 5\% of entries into missing
A <- aux.rndmissing(lena64, x=0.05)

## apply the method
filled <- fill.nuclear(A)

## visualize
par(mfrow=c(1,2), pty="s")
image(A, col=gray((0:100)/100), axes=FALSE, main="5\% missing")
image(filled$X, col=gray((0:100)/100), axes=FALSE, main="processed")


}
\references{
\insertRef{candes_exact_2009}{filling}
}
