% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findInGit.R
\name{findInGit-shiny}
\alias{findInGit-shiny}
\alias{FIGOutput}
\alias{renderFIG}
\title{Shiny bindings for \code{findInGit}}
\usage{
FIGOutput(outputId, width = "100\%", height = "400px")

renderFIG(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended}

\item{expr}{an expression that generates a '\code{\link{findInGit}}' widget}

\item{env}{the environment in which to evaluate \code{expr}}

\item{quoted}{logical, whether \code{expr} is a quoted expression (with
\code{quote()})}
}
\value{
\code{FIGOutput} returns an output element that can be included in a
  Shiny UI definition, and \code{renderFIG} returns a
  \code{shiny.render.function} object that can be included in a Shiny
  server definition.
}
\description{
Output and render functions for using \code{findInGit} within Shiny
applications and interactive Rmd documents.
}
\examples{
library(findInGit)
library(shiny)

# First, we create a temporary git repo
library(R.utils) # to use the `copyDirectory` function
folder1 <- system.file("htmlwidgets", package = "findInGit")
folder2 <- system.file("htmlwidgets", "lib", package = "findInGit")
tmpDir <- paste0(tempdir(), "_gitrepo")
dir.create(tmpDir)
# set tmpDir as the working directory
cd <- setwd(tmpDir)
# copy folder1 in tmpDir
copyDirectory(folder1, recursive = FALSE)
# initialize git repo
system("git init")
# add all files to git
system("git add -A")
# commit files
system('git commit -m "mycommit1"')
# create a new branch
system("git checkout -b newbranch")
# copy folder2 in tmpDir, under the new branch
copyDirectory(folder2, recursive = FALSE)
# add all files to git
system("git add -A")
# commit files
system('git commit -m "mycommit2"')

# Now let's play with Shiny
onKeyDown <- HTML(
  'function onKeyDown(event) {',
  '  var key = event.which || event.keyCode;',
  '  if(key === 13) {',
  '    Shiny.setInputValue(',
  '      "pattern", event.target.value, {priority: "event"}',
  '    );',
  '  }',
  '}'
)

ui <- fluidPage(
  tags$head(tags$script(onKeyDown)),
  br(),
  sidebarLayout(
    sidebarPanel(
      selectInput(
        "ext", "Extension",
        choices = c("js", "css")
      ),
      tags$div(
        class = "form-group shiny-input-container",
        tags$label(
          class = "control-label",
          "Pattern"
        ),
        tags$input(
          type = "text",
          class = "form-control",
          onkeydown = "onKeyDown(event);",
          placeholder = "Press Enter when ready"
        )
      ),
      checkboxInput(
        "wholeWord", "Whole word"
      ),
      checkboxInput(
        "ignoreCase", "Ignore case"
      )
    ),
    mainPanel(
      FIGOutput("results")
    )
  )
)

Clean <- function(){
  setwd(cd)
  unlink(tmpDir, recursive = TRUE, force = TRUE)
}

server <- function(input, output){

  onSessionEnded(Clean)

  output[["results"]] <- renderFIG({
    req(input[["pattern"]])
    findInGit(
      ext = isolate(input[["ext"]]),
      pattern = input[["pattern"]],
      wholeWord = isolate(input[["wholeWord"]]),
      ignoreCase = isolate(input[["ignoreCase"]])
    )
  })

}

if(interactive()){
  shinyApp(ui, server)
}else{
  Clean()
}
}
