% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-component-graph-heavy-tail.R
\name{learn_kcomp_heavytail_graph}
\alias{learn_kcomp_heavytail_graph}
\title{Laplacian matrix of a k-component graph with heavy-tailed data

Computes the Laplacian matrix of a graph on the basis of an observed data matrix,
where we assume the data to be Student-t distributed.}
\usage{
learn_kcomp_heavytail_graph(
  X,
  k = 1,
  heavy_type = "gaussian",
  nu = NULL,
  w0 = "naive",
  d = 1,
  beta = 1e-08,
  update_beta = TRUE,
  early_stopping = FALSE,
  rho = 1,
  update_rho = FALSE,
  maxiter = 10000,
  reltol = 1e-05,
  verbose = TRUE,
  record_objective = FALSE
)
}
\arguments{
\item{X}{an n x p data matrix, where n is the number of observations and p is
the number of nodes in the graph.}

\item{k}{the number of components of the graph.}

\item{heavy_type}{a string which selects the statistical distribution of the data    .
Valid values are "gaussian" or "student".}

\item{nu}{the degrees of freedom of the Student-t distribution.
Must be a real number greater than 2.}

\item{w0}{initial vector of graph weights. Either a vector of length p(p-1)/2 or
a string indicating the method to compute an initial value.}

\item{d}{the nodes' degrees. Either a vector or a single value.}

\item{beta}{hyperparameter that controls the regularization to obtain a
k-component graph}

\item{update_beta}{whether to update beta during the optimization.}

\item{early_stopping}{whether to stop the iterations as soon as the rank
constraint is satisfied.}

\item{rho}{constraint relaxation hyperparameter.}

\item{update_rho}{whether or not to update rho during the optimization.}

\item{maxiter}{maximum number of iterations.}

\item{reltol}{relative tolerance as a convergence criteria.}

\item{verbose}{whether to show a progress bar during the iterations.}

\item{record_objective}{whether to record the objective function per iteration.}
}
\value{
A list containing possibly the following elements:
\item{\code{laplacian}}{estimated Laplacian matrix}
\item{\code{adjacency}}{estimated adjacency matrix}
\item{\code{theta}}{estimated Laplacian matrix slack variable}
\item{\code{maxiter}}{number of iterations taken to reach convergence}
\item{\code{convergence}}{boolean flag to indicate whether or not the optimization conv        erged}
\item{\code{beta_seq}}{sequence of values taken by the hyperparameter beta until convergence}
\item{\code{primal_lap_residual}}{primal residual for the Laplacian matrix per iteratio    n}
\item{\code{primal_deg_residual}}{primal residual for the degree vector per iteration}
\item{\code{dual_residual}}{dual residual per iteration}
\item{\code{lagrangian}}{Lagrangian value per iteration}
\item{\code{elapsed_time}}{Time taken to reach convergence}
}
\description{
Laplacian matrix of a k-component graph with heavy-tailed data

Computes the Laplacian matrix of a graph on the basis of an observed data matrix,
where we assume the data to be Student-t distributed.
}
