% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data.R
\name{prep_data}
\alias{prep_data}
\title{Prep Data}
\usage{
prep_data(
  run_info,
  input_data,
  combo_variables,
  target_variable,
  date_type,
  forecast_horizon,
  external_regressors = NULL,
  hist_start_date = NULL,
  hist_end_date = NULL,
  combo_cleanup_date = NULL,
  fiscal_year_start = 1,
  clean_missing_values = TRUE,
  clean_outliers = FALSE,
  box_cox = TRUE,
  stationary = TRUE,
  forecast_approach = "bottoms_up",
  parallel_processing = NULL,
  num_cores = NULL,
  target_log_transformation = FALSE,
  fourier_periods = NULL,
  lag_periods = NULL,
  rolling_window_periods = NULL,
  recipes_to_run = NULL
)
}
\arguments{
\item{run_info}{Run info using \code{\link[=set_run_info]{set_run_info()}}}

\item{input_data}{A standard data frame, tibble, or spark data frame using sparklyr of historical time series data.
Can also include external regressors for both historical and future data.}

\item{combo_variables}{List of column headers within input data to be used to separate individual time series.}

\item{target_variable}{The column header formatted as a character value within input data you want to forecast.}

\item{date_type}{The date granularity of the input data. Finn accepts the following as a character string:
day, week, month, quarter, year.}

\item{forecast_horizon}{Number of periods to forecast into the future.}

\item{external_regressors}{List of column headers within input data to be used as features in multivariate models.}

\item{hist_start_date}{Date value of when your input_data starts. Default of NULL uses earliest date value in
input_data.}

\item{hist_end_date}{Date value of when your input_data ends. Default of NULL uses the latest date value in
input_data.}

\item{combo_cleanup_date}{Date value to remove individual time series that don't contain non-zero values after
that specified date. Default of NULL is to not remove any time series and attempt to forecast all time series.}

\item{fiscal_year_start}{Month number of start of fiscal year of input data, aids in building out date features.
Formatted as a numeric value. Default of 1 assumes fiscal year starts in January.}

\item{clean_missing_values}{If TRUE, cleans missing values. Only impute values for missing data within an
existing series, and does not add new values onto the beginning or end, but does provide a value of 0 for said
values.}

\item{clean_outliers}{If TRUE, outliers are cleaned and inputted with values more in line with historical data.}

\item{box_cox}{Apply box-cox transformation to normalize variance in data}

\item{stationary}{Apply differencing to make data stationary}

\item{forecast_approach}{How the forecast is created. The default of 'bottoms_up' trains models for each individual
time series. Value of 'grouped_hierarchy' creates a grouped time series to forecast at while 'standard_hierarchy' creates
a more traditional hierarchical time series to forecast, both based on the hts package.}

\item{parallel_processing}{Default of NULL runs no parallel processing and forecasts each individual time series
one after another. Value of 'local_machine' leverages all cores on current machine Finn is running on.
Value of 'spark' runs time series in parallel on a spark cluster in Azure Databricks/Synapse.}

\item{num_cores}{Number of cores to run when parallel processing is set up. Used when running parallel computations
on local machine or within Azure. Default of NULL uses total amount of cores on machine minus one. Can't be greater
than number of cores on machine minus 1.}

\item{target_log_transformation}{If TRUE, log transform target variable before training models.}

\item{fourier_periods}{List of values to use in creating fourier series as features. Default of NULL automatically chooses
these values based on the date_type.}

\item{lag_periods}{List of values to use in creating lag features. Default of NULL automatically chooses these values
based on date_type.}

\item{rolling_window_periods}{List of values to use in creating rolling window features. Default of NULL automatically
chooses these values based on date_type.}

\item{recipes_to_run}{List of recipes to run on multivariate models that can run different recipes. A value of NULL runs
all recipes, but only runs the R1 recipe for weekly and daily date types. A value of "all" runs all recipes, regardless
of date type. A list like c("R1") or c("R2") would only run models with the R1 or R2 recipe.}
}
\value{
No return object. Feature engineered data is written to disk based on the output locations provided in
\code{\link[=set_run_info]{set_run_info()}}.
}
\description{
Preps data with various feature engineering recipes to create features before training models
}
\examples{
\donttest{
data_tbl <- timetk::m4_monthly \%>\%
  dplyr::rename(Date = date) \%>\%
  dplyr::mutate(id = as.character(id)) \%>\%
  dplyr::filter(
    Date >= "2013-01-01",
    Date <= "2015-06-01"
  )

run_info <- set_run_info()

prep_data(run_info,
  input_data = data_tbl,
  combo_variables = c("id"),
  target_variable = "value",
  date_type = "month",
  forecast_horizon = 3,
  recipes_to_run = "R1"
)
}
}
