% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPoly.r
\name{convertStartmeans}
\alias{convertStartmeans}
\title{A function to convert a set of mixture means from one ploidy to another}
\usage{
convertStartmeans(ploidy, origmeans)
}
\arguments{
\item{ploidy}{The ploidy to which the means must be converted.}

\item{origmeans}{A data.frame with a first column MarkerName, followed
by <oldploidy+1> columns (names are ignored) that contain the ratio means
for dosages 0 to <oldploidy>. Column MarkerName may not contain missing values.
On each row the other columns must either all contain NA, or only non-NA
values between 0 and 1 in strictly ascending order.}
}
\value{
A data.frame like origmeans with the same column MarkerName, now
followed by <ploidy+1> columns with the new means.
}
\description{
convertStartmeans takes a set of means at one ploidy level (e.g.
the fitted means for a tetraploid data set)
and uses them to generate a set of means for another ploidy level (e.g. as
startmeans for fitting triploid data for the same markers).
}
\details{
The new means are calculated by linear interpolation between the old
means on the asin(sqrt(x)) transformed scale and back-transformed to the
original scale; the new means for dosage 0 are equal to the old, and the
new means for dosage <ploidy> are equal to the old means for dosage
<oldploidy>.
}
\examples{
# means from tetraploid data set:
tetrameans <- data.frame(MarkerName=c("mrk1", "mrk2"), mu0=c(0.02, 0.0),
mu1=c(0.2, 0.25), mu2=c(0.3, 0.5), mu3=c(0.4, 0.75), mu4=c(0.6, 1.0))
# convert to means for triploid data set:
trimeans <- convertStartmeans(ploidy=3, origmeans=tetrameans)
tetrameans
trimeans

}
