% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{i}
\alias{i}
\alias{interact}
\title{Create, or interact variables with, factors}
\usage{
i(var, f, f2, ref, drop, keep, drop2, keep2)

interact(var, f, f2, ref, drop, keep, drop2, keep2)
}
\arguments{
\item{var}{A vector to be interacted with \code{f}. If the other argument \code{f} is missing, then this vector will be treated as the argument \code{f}.}

\item{f}{A vector (of any type) that will be treated as a factor. Must be of the same length as \code{var} if \code{var} is not missing.}

\item{f2}{A vector (of any type) that will be treated as a factor. Must be of the same length as \code{f}.}

\item{ref}{A single value that belongs to the interacted variable (\code{f}). Can be missing, can also be a logical: if \code{TRUE}, then the first value of \code{f} will be removed..}

\item{drop}{A vector of regular expressions or integers (if \code{f} is integer). If provided, all values from \code{f} that match \code{drop} will be removed.}

\item{keep}{A vector of regular expressions or integers (if \code{f} is integer). If provided, only the values from \code{f} that match \code{keep} will be kept.}

\item{drop2}{A vector of regular expressions or integers (if \code{f2} is integer). If provided, all values from \code{f2} that match \code{drop2} will be removed.}

\item{keep2}{A vector of regular expressions or integers (if \code{f2} is integer). If provided, only the values from \code{f2} that match \code{keep2} will be kept.}
}
\value{
It returns a matrix with number of rows the length of \code{var}. The number of columns is equal to the number of cases contained in \code{f} minus the reference(s).
}
\description{
Treat a variable as a factor, or interacts a variable with another treated as a factor. Values to be dropped/kept from the factor can be easily set. Note that to interact fixed-effects, this function should not be used: instead use directly the syntax \code{fe1^fe2}.
}
\details{
To interact fixed-effects, this function should not be used: instead use directly the syntax \code{fe1^fe2} in the fixed-effects part of the formula. Please see the details and examples in the help page of \code{\link[fixest]{feols}}.
}
\section{Shorthand in \code{fixest} estimations}{

In \code{fixest} estimations, instead of using \code{i(var, f, ref)}, you can instead use the following writing \code{var::f(ref)}. Note that this way of doing interactions is not endorsed any more and will likely be deprecated in the future.
}

\examples{

#
# Simple illustration
#

x = 1:10
y = rep(1:4, 3)[1:10]

# interaction
cbind(x, y, i(x, y, 1))

# without interaction
cbind(x, y, i(y, ref = 1))

# You can interact factors too
z = rep(c("a", "b", "c"), c(5, 3, 2))
data.frame(z, y, i(z, y))

#
# In fixest estimations
#

data(base_did)
# We interact the variable 'period' with the variable 'treat'
est_did = feols(y ~ x1 + i(treat, period, 5) | id + period, base_did)

# => special treatment in coefplot
coefplot(est_did)

# Using i() for factors
est_bis = feols(y ~ x1 + i(period, keep = 3:6) + i(treat, period, 5) | id, base_did)

coefplot(est_bis, only.inter = FALSE)

# => special treatment in etable
etable(est_bis, dict = c("6" = "six"))

#
# Interact two factors => f2
#

# To interact two factor, use the argument f2
data(airquality)
aq = airquality
aq$week = aq$Day \%/\% 7 + 1

# Interacting Month and week:
res_2F = feols(Ozone ~ Solar.R + i(Month, f2 = week), aq)

# Same but dropping the 5th Month and 1st week
res_2F_bis = feols(Ozone ~ Solar.R + i(Month, f2 = week, drop = 5, drop2 = 1), aq)

etable(res_2F, res_2F_bis)

}
\seealso{
\code{\link[fixest]{coefplot}} to plot interactions, \code{\link[fixest]{feols}} for OLS estimation with multiple fixed-effects.
}
\author{
Laurent Berge
}
