% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_stats.R
\name{grouped_stats}
\alias{grouped_stats}
\title{Grouped Weighted Means, Quartiles, or Variances}
\usage{
grouped_stats(
  data,
  x,
  w = NULL,
  by = NULL,
  stats = c("mean", "quartiles", "variance"),
  counts = TRUE,
  counts_weighted = FALSE,
  counts_name = "counts",
  value_name = x,
  q1_name = "q1",
  q3_name = "q3",
  ...
)
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{x}{Variable name in \code{data} to summarize.}

\item{w}{Optional name of the column in \code{data} with case weights.}

\item{by}{An optional vector of column names in \code{data} used to group the results.}

\item{stats}{Statistic to calculate: "mean", "quartiles", or "variance".}

\item{counts}{Should group counts be added?}

\item{counts_weighted}{Should counts be weighted by the case weights? If TRUE, the sum of \code{w} is returned by group.}

\item{counts_name}{Name of column in the resulting \code{data.frame} containing the counts.}

\item{value_name}{Name of the resulting column with mean, median, or variance.}

\item{q1_name}{Name of the resulting column with first quartile values. Only relevant for \code{stats} "quartiles".}

\item{q3_name}{Name of the resulting column with third quartile values. Only relevant for \code{stats} "quartiles".}

\item{...}{Additional arguments passed to \code{MetricsWeighted::weighted_mean}, \code{MetricsWeighted::weighted_quartiles}, or \code{MetricsWeighted::weighted_var}.}
}
\value{
A \code{data.frame} with columns \code{by}, \code{x} and optionally \code{counts_name}.
}
\description{
Calculates weighted means, quartiles, or variances (and counts) of a variable grouped by optional columns.
}
\examples{
grouped_stats(iris, "Sepal.Width")
grouped_stats(iris, "Sepal.Width", stats = "quartiles")
grouped_stats(iris, "Sepal.Width", stats = "variance")
grouped_stats(iris, "Sepal.Width", w = "Petal.Width")
grouped_stats(iris, "Sepal.Width", w = "Petal.Width", counts_weighted = TRUE)

grouped_stats(iris, "Sepal.Width", by = "Species")
grouped_stats(iris, "Sepal.Width", stats = "quartiles", by = "Species")
grouped_stats(iris, "Sepal.Width", stats = "variance", by = "Species")
grouped_stats(iris, "Sepal.Width", w = "Petal.Width", by = "Species")
grouped_stats(iris, "Sepal.Width", w = "Petal.Width",
  counts_weighted = TRUE, by = "Species")

grouped_stats(iris, "Sepal.Width", counts = FALSE)
grouped_stats(iris, "Sepal.Width", counts_name = "n",
  stats = "quartiles", q1_name = "p25", q3_name = "p75")
}
