% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_light_importance.R
\name{plot.light_importance}
\alias{plot.light_importance}
\title{Visualize Variable Importance}
\usage{
\method{plot}{light_importance}(
  x,
  top_m = Inf,
  swap_dim = FALSE,
  facet_scales = "fixed",
  rotate_x = FALSE,
  error_bars = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{light_importance}.}

\item{top_m}{Maximum number of important variables to be returned.}

\item{swap_dim}{If multiflashlight and one "by" variable or single flashlight with two "by" variables, swap the role of dodge/fill variable and facet variable. If multiflashlight or one "by" variable, use facets instead of colors.}

\item{facet_scales}{Scales argument passed to \code{facet_wrap}.}

\item{rotate_x}{Should x axis labels be rotated by 45 degrees? Default is FALSE.}

\item{error_bars}{Should error bars be added? Defaults to TRUE. Only available if \code{light_importance} was run with multiple permutations, i.e. by setting \code{m_repetitions} > 1.}

\item{...}{Further arguments passed to \code{geom_bar}.}
}
\value{
An object of class \code{ggplot2}.
}
\description{
Minimal visualization of an object of class \code{light_importance} as \code{geom_bar}. If available, standard errors are added as \code{geom_errorbar}. The object returned is of class \code{ggplot} and can be further customized.
}
\details{
The plot is organized as a bar plot with variable names as x-aesthetic. Up to two additional dimensions (multiflashlight and one "by" variable or single flashlight with two "by" variables) can be visualized by facetting and dodge/fill. Set \code{swap_dim = FALSE} to revert the role of these two dimensions. One single additional dimension is visualized by a facet wrap, or - if \code{swap_dim = FALSE} - by dodge/fill.
}
\examples{
fit_full <- lm(Sepal.Length ~ ., data = iris)
fit_part <- lm(Sepal.Length ~ Petal.Length, data = iris)
mod_full <- flashlight(model = fit_full, label = "full", data = iris, y = "Sepal.Length")
mod_part <- flashlight(model = fit_part, label = "part", data = iris, y = "Sepal.Length")
mods <- multiflashlight(list(mod_full, mod_part), by = "Species")
plot(light_importance(mod_part, m_repetitions = 4), fill = "darkred")
plot(light_importance(mods), swap_dim = TRUE)
}
\seealso{
\code{\link{light_importance}}.
}
