% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{font}
\alias{font}
\title{Set font}
\usage{
font(x, i = NULL, j = NULL, fontname, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{fontname}{string value, the font name.}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
change font of selected rows and columns of a flextable.
}
\examples{
require("gdtools")
fontname <- "Times"

if( !font_family_exists(fontname) ){
  # if Times is not available, we will use the first available
  font_list <- sys_fonts()
  fontname <- as.character(font_list$family[1])
}

ft <- flextable(head(iris))
ft <- font(ft, fontname = fontname, part = "header")
}
