% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtable_to_flextable.R
\name{xtable_to_flextable}
\alias{xtable_to_flextable}
\title{get a flextable from a xtable object}
\usage{
xtable_to_flextable(
  x,
  text.properties = officer::fp_text(),
  format.args = getOption("xtable.format.args", NULL),
  rowname_col = "rowname",
  hline.after = getOption("xtable.hline.after", c(-1, 0, nrow(x))),
  NA.string = getOption("xtable.NA.string", ""),
  include.rownames = TRUE,
  rotate.colnames = getOption("xtable.rotate.colnames", FALSE)
)
}
\arguments{
\item{x}{\code{xtable} object}

\item{text.properties}{default text formatting properties}

\item{format.args}{List of arguments for the formatC function.
See argument \code{format.args} of \code{print.xtable}. Not yet
implemented.}

\item{rowname_col}{colname used for row names column}

\item{hline.after}{see \code{?print.xtable}.}

\item{NA.string}{see \code{?print.xtable}.}

\item{include.rownames}{see \code{?print.xtable}.}

\item{rotate.colnames}{see \code{?print.xtable}.}
}
\description{
Get a \code{flextable} object from
a \code{xtable} object.
}
\examples{
library(officer)
if( require("xtable") ){

  data(tli)
  tli.table <- xtable(tli[1:10, ])
  align(tli.table) <- rep("r", 6)
  align(tli.table) <- "|r|r|clr|r|"
  ft <- xtable_to_flextable(
    tli.table,
    rotate.colnames = TRUE,
    include.rownames = FALSE)
  ft <- height(ft, i = 1, part = "header", height = 1)
  ft

  \donttest{
  Grade3 <- c("A","B","B","A","B","C","C","D","A","B",
    "C","C","C","D","B","B","D","C","C","D")
  Grade6 <- c("A","A","A","B","B","B","B","B","C","C",
    "A","C","C","C","D","D","D","D","D","D")
  Cohort <- table(Grade3, Grade6)
  ft <- xtable_to_flextable(xtable(Cohort))
  ft <- set_header_labels(ft, rowname = "Grade 3")
  ft <- autofit(ft)
  ft <- add_header(ft, A = "Grade 6")
  ft <- merge_at(ft, i = 1, j = seq_len( ncol(Cohort) ) + 1,
    part = "header" )
  ft <- bold(ft, j = 1, bold = TRUE, part = "body")
  ft <- height_all(ft, part = "header", height = .4)
  ft

  temp.ts <- ts(cumsum(1 + round(rnorm(100), 0)),
    start = c(1954, 7), frequency = 12)
  xtable_to_flextable(x = xtable(temp.ts, digits = 0),
    NA.string = "-")
  }
}
}
