% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{padding}
\alias{padding}
\title{Set paragraph paddings}
\usage{
padding(
  x,
  i = NULL,
  j = NULL,
  padding = NULL,
  padding.top = NULL,
  padding.bottom = NULL,
  padding.left = NULL,
  padding.right = NULL,
  part = "body"
)
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{padding}{padding (shortcut for top, bottom, left and right)}

\item{padding.top}{padding top}

\item{padding.bottom}{padding bottom}

\item{padding.left}{padding left}

\item{padding.right}{padding right}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
change paddings of selected rows and columns of a flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_padding_1.png}{options: width=50\%}}
}

\examples{
ft_1 <- flextable(head(iris))
ft_1 <- theme_vader(ft_1)
ft_1 <- padding(ft_1, padding.top = 4, part = "all")
ft_1 <- padding(ft_1, j = 1, padding.right = 40)
ft_1 <- padding(ft_1, i = 3, padding.top = 40)
ft_1 <- padding(ft_1, padding.top = 10, part = "header")
ft_1 <- padding(ft_1, padding.bottom = 10, part = "header")
ft_1 <- autofit(ft_1)
ft_1
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{fontsize}()},
\code{\link{font}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{line_spacing}()},
\code{\link{rotate}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
