% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{as_paragraph}
\alias{as_paragraph}
\title{concatenate chunks in a flextable}
\usage{
as_paragraph(..., list_values = NULL)
}
\arguments{
\item{...}{chunk elements that are defining paragraph}

\item{list_values}{a list of chunk elements that are defining paragraph. If
specified argument \code{...} is unused.}
}
\description{
The function is concatenating text and images within paragraphs of
a flextable object, this function is to be used with function \code{\link[=compose]{compose()}}.
}
\section{Illustrations}{


\if{html}{\figure{fig_as_paragraph_1.png}{options: width=60\%}}
}

\examples{
library(officer)
ft <- flextable( head(iris, n = 10 ))

ft <- compose(ft, j = 1,
  value = as_paragraph(
    minibar(value = Sepal.Length, max = max(Sepal.Length)),
    " ",
    as_chunk( Sepal.Length, formatter = formatC,
             props = fp_text(color = "orange") ),
    " blah blah"
  ),
  part = "body")

ft <- autofit(ft)
ft
}
\seealso{
\code{\link[=as_chunk]{as_chunk()}}, \code{\link[=minibar]{minibar()}},
\code{\link[=as_image]{as_image()}}, \code{\link[=hyperlink_text]{hyperlink_text()}}
}
