% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{add_footer_row}
\alias{add_footer_row}
\title{Add footer labels}
\usage{
add_footer_row(x, top = TRUE, values = character(0), colwidths = integer(0))
}
\arguments{
\item{x}{a flextable object}

\item{top}{should the row be inserted at the top or the bottom.}

\item{values}{values to add. It can be a \code{list} or a \code{character()} vector.
If it is a list, it must be a named list using the names of the columns of the
original data.frame or the \code{colkeys}; this is the recommended method because
it allows to keep the original data types and therefore allows to perform
conditional formatting. If a character, columns of the original data.frame
stored in the flextable object are changed to \code{character()}; this is often
not an issue with footer and header but can be inconvenient if adding
rows into body as it will change data types to character and prevent
efficient conditional formatting.}

\item{colwidths}{the number of columns to merge in the row for each label}
}
\description{
Add a row of new columns labels in footer part.
Labels can be spanned along multiple columns, as merged cells.

Labels are associated with a number of columns
to merge that default to one if not specified.
In this case, you have to make sure that the
number of labels is equal to the number of columns displayed.

The function can add only one single row by call.
}
\section{Illustrations}{

\if{html}{\figure{fig_add_footer_row_1.png}{options: width="300"}}
}

\examples{
ft_1 <- flextable(head(iris))
ft_1 <- add_footer_row(ft_1,
  values = "blah blah", colwidths = 5
)
ft_1 <- add_footer_row(ft_1,
  values = c("blah", "blah"),
  colwidths = c(3, 2)
)
ft_1
}
\seealso{
Other functions that add lines in the table: 
\code{\link{add_body_row}()},
\code{\link{add_body}()},
\code{\link{add_footer_lines}()},
\code{\link{add_footer}()},
\code{\link{add_header_row}()},
\code{\link{add_header}()}

Other functions to add rows in header or footer: 
\code{\link{add_footer_lines}()},
\code{\link{add_footer}()},
\code{\link{add_header_lines}()},
\code{\link{add_header_row}()},
\code{\link{add_header}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions that add lines in the table}
\concept{functions to add rows in header or footer}
