% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.R
\name{as_flextable.glm}
\alias{as_flextable.glm}
\title{Transform a 'glm' object into a flextable}
\usage{
\method{as_flextable}{glm}(x, ...)
}
\arguments{
\item{x}{glm model}

\item{...}{unused argument}
}
\description{
produce a flextable describing a
generalized linear model produced by function \code{glm}.
}
\examples{
if(require("broom")){
  dat <- attitude
  dat$high.rating <- (dat$rating > 70)
  probit.model <- glm(high.rating ~ learning + critical +
     advance, data=dat, family = binomial(link = "probit"))
  ft <- as_flextable(probit.model)
  ft
}
}
\seealso{
Other as_flextable methods: 
\code{\link{as_flextable.data.frame}()},
\code{\link{as_flextable.gam}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.kmeans}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.merMod}()},
\code{\link{as_flextable.pam}()},
\code{\link{as_flextable.summarizor}()},
\code{\link{as_flextable.tabular}()},
\code{\link{as_flextable.tabulator}()},
\code{\link{as_flextable.xtable}()},
\code{\link{as_flextable}()}
}
\concept{as_flextable methods}
