% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{hyperlink_text}
\alias{hyperlink_text}
\title{Chunk of text with hyperlink}
\usage{
hyperlink_text(x, props = NULL, formatter = format_fun, url, ...)
}
\arguments{
\item{x}{text or any element that can be formatted as text
with function provided in argument \code{formatter}.}

\item{props}{an \code{\link[=fp_text_default]{fp_text_default()}} or \code{\link[officer:fp_text]{officer::fp_text()}} object to be used to format the text.
If not specified, it will be the default value corresponding to the cell.}

\item{formatter}{a function that will format x as a character vector.}

\item{url}{url to be used}

\item{...}{additional arguments for \code{formatter} function.}
}
\description{
The function lets add hyperlinks within flextable
objects.

It is used to add it to the content of a cell of the
flextable with the functions \code{\link[=compose]{compose()}}, \code{\link[=append_chunks]{append_chunks()}}
or \code{\link[=prepend_chunks]{prepend_chunks()}}.

URL are not encoded, they are preserved 'as is'.
}
\note{
This chunk option requires package officedown in a R Markdown
context with Word output format.
}
\examples{
dat <- data.frame(
  col = "Google it",
  href = "https://www.google.fr/search?source=hp&q=flextable+R+package",
  stringsAsFactors = FALSE)

ftab <- flextable(dat)
ftab <- compose( x = ftab, j = "col",
  value = as_paragraph(
    "This is a link: ",
    hyperlink_text(x = col, url = href ) ) )
ftab
}
\seealso{
\code{\link[=compose]{compose()}}

Other chunk elements for paragraph: 
\code{\link{as_bracket}()},
\code{\link{as_b}()},
\code{\link{as_chunk}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_image}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{as_word_field}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{grid_chunk}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
