% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R
\name{set_caption}
\alias{set_caption}
\title{Set Caption}
\usage{
set_caption(
  x,
  caption = NULL,
  autonum = NULL,
  word_stylename = "Table Caption",
  style = word_stylename,
  fp_p = fp_par(padding = 3),
  align_with_table = TRUE,
  html_classes = NULL,
  html_escape = TRUE
)
}
\arguments{
\item{x}{flextable object}

\item{caption}{caption value. The caption can be either a string either
a call to \code{\link[=as_paragraph]{as_paragraph()}}. In the latter case, users are free to format
the caption with colors, italic fonts, also mixed with images or
equations. Note that Quarto does not allow the use of this feature.

Caption as a string does not support 'Markdown' syntax. If you want to
add a bold text in the caption, use \code{as_paragraph('a ', as_b('bold'), ' text')}
when providing caption.}

\item{autonum}{an autonum representation. See \code{\link[officer:run_autonum]{officer::run_autonum()}}.
This has an effect only when the output is "Word" (in which case the object
is used to define the Word auto-numbering), "html" and "pdf" (in which case only
the bookmark identifier will be used). If used, the caption is preceded
by an auto-number sequence.}

\item{word_stylename, style}{'Word' style name to associate with caption paragraph. These names are available with
function \code{\link[officer:styles_info]{officer::styles_info()}} when output is Word. Argument \code{style}
is deprecated in favor of \code{word_stylename}. If the caption is defined with
\code{as_paragraph()}, some of the formattings of the paragraph style will be
replaced by the formattings associated with the chunks (such as the font).}

\item{fp_p}{paragraph formatting properties associated with the caption, see \code{\link[=fp_par]{fp_par()}}.
It applies when possible, i.e. in HTML and 'Word' but not with bookdown.}

\item{align_with_table}{if TRUE, caption is aligned as the flextable, if FALSE,
\code{fp_p} will not be updated and alignement is as defined with \code{fp_p}.
It applies when possible, i.e. in HTML and 'Word' but not with bookdown.}

\item{html_classes}{css class(es) to apply to associate with caption paragraph
when output is 'Word'.}

\item{html_escape}{should HTML entities be escaped so that it can be safely
included as text or an attribute value within an HTML document.}
}
\description{
Set caption value in a flextable. The function
can also be used to define formattings that will be applied
if possible to Word and HTML outputs.
\itemize{
\item The caption will be associated with a paragraph style when
the output is Word. It can also be numbered as a auto-numbered
Word computed value.
\item The PowerPoint format ignores captions. PowerPoint documents are not
structured and do not behave as HTML documents and paginated documents
(word, pdf), and it's not possible to know where we should create
a shape to contain the caption (technically it can't be in the
PowerPoint shape containing the table).
}

When working with 'R Markdown' or 'Quarto', the caption settings
defined with \code{set_caption()} will be prioritized over knitr chunk options.

Caption value can be a single string or the result to a call to
\code{\link[=as_paragraph]{as_paragraph()}}. With the latter, the caption is made of
formatted chunks whereas with the former, caption will not be
associated with any formatting.
}
\details{
The behavior of captions in the 'flextable' package varies depending on the formats
and technologies used.

The values set by the \code{set_caption()} function will be prioritized whenever
possible, including the caption ID and associated paragraph style.
However, it's important to note that the behavior may differ across different tools.
Here's what we have observed and attempted to respect, but please inform us
if you believe our observations are incorrect:
\itemize{
\item In Word and HTML documents created with 'rmarkdown' \code{rmarkdown::word_document()}
and \code{rmarkdown::html_document()}, numbered and cross-referenced captions are not
typically expected.
\item In PDF documents created with 'rmarkdown' \code{rmarkdown::pdf_document()}, numbers
are automatically added before the caption.
\item In Word and HTML documents created with 'bookdown', numbered and cross-referenced
captions are expected. 'bookdown' handles this functionality, but due to
technical reasons, the caption should not be defined within an HTML or XML block.
Therefore, when using 'flextable', the ability to format the caption content is
lost (this limitation does not apply to PDF documents).
\item HTML and PDF documents created with Quarto handle captions and
cross-references differently. Quarto replaces captions with 'tbl-cap' and 'label'
values.
\item Word documents created with Quarto present another specific case.
Currently, Quarto does not inject captions using the 'tbl-cap' and label values.
However, this is a temporary situation that is expected to change in the future.
The 'flextable' package will adapt accordingly as Quarto evolves.
\item When using the \code{body_add_flextable()} function, all the options
specified with \code{set_caption()} will be enabled.
}

Using \code{\link[=body_add_flextable]{body_add_flextable()}} enable all options specified with \code{set_caption()}.
}
\section{R Markdown}{


flextable captions can be defined from R Markdown documents by using
\code{knitr::opts_chunk$set()}. User don't always have to call \code{set_caption()}
to set a caption, he can use knitr chunk options instead. A typical call
would be:

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r\}
#| tab.id: bookmark_id
#| tab.cap: caption text
flextable(head(cars))
```
}\if{html}{\out{</div>}}

\code{tab.id} is the caption id or bookmark, \code{tab.cap} is the caption
text. There are many options that can replace \code{set_caption()}
features. The following knitr chunk options are available:\tabular{lcc}{
   \strong{label} \tab \strong{name} \tab \strong{value} \cr
   Word stylename to use for table captions. \tab tab.cap.style \tab NULL \cr
   caption id/bookmark \tab tab.id \tab NULL \cr
   caption \tab tab.cap \tab NULL \cr
   display table caption on top of the table or not \tab tab.topcaption \tab TRUE \cr
   caption table sequence identifier. \tab tab.lp \tab "tab:" \cr
   prefix for numbering chunk (default to   "Table "). \tab tab.cap.pre \tab Table \cr
   suffix for numbering chunk (default to   ": "). \tab tab.cap.sep \tab " :" \cr
   title number depth \tab tab.cap.tnd \tab 0 \cr
   separator to use between title number and table number. \tab tab.cap.tns \tab "-" \cr
   caption prefix formatting properties \tab tab.cap.fp_text \tab fp_text_lite(bold = TRUE) \cr
}


See \link{knit_print.flextable} for more details.
}

\section{Formatting the caption}{


To create captions in R Markdown using the 'flextable' package and 'officer'
package, you can utilize the \code{as_paragraph()} function. This approach is
recommended when your captions require complex content, such as a combination of
different text styles or the inclusion of images and equations.

The caption is constructed as a paragraph consisting of multiple chunks. Each
chunk represents a specific portion of the caption with its desired formatting,
such as red bold text or Arial italic text.

By default, if no specific formatting is specified (using either "a string" or
\code{as_chunk("a string")}), the \code{fp_text_default()} function sets the font settings
for the caption, including the font family, boldness, italics, color, etc. The
default values can be modified using the \code{set_flextable_defaults()} function.
However, it is recommended to explicitly use \code{as_chunk()} to define the desired
formatting.

It's important to note that the style properties of the caption will not
override the formatting of the individual elements within it. Therefore, you
need to explicitly specify the font to be used for the caption.

Here's an example of how to set a caption for a flextable in R Markdown using
the 'officer' package:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(flextable)
library(officer)

ftab <- flextable(head(cars)) \%>\%
  set_caption(
    as_paragraph(
      as_chunk("caption", props = fp_text_default(font.family = "Cambria"))
    ), word_stylename = "Table Caption"
  )

print(ftab, preview = "docx")
}\if{html}{\out{</div>}}

In this example, the \code{set_caption()} function sets the caption for the
flextable. The caption is created using \code{as_paragraph()} with a single chunk
created using \code{as_chunk("caption", props = fp_text_default(font.family = "Cambria"))}. The \code{word_stylename} parameter is used to specify the table
caption style in the resulting Word document. Finally, the \code{print()} function
generates the flextable with the caption, and \code{preview = "docx"} displays a
preview of the resulting Word document.
}

\section{Using 'Quarto'}{


In 'Quarto', captions and cross-references are handled differently
compared to 'R Markdown', where flextable takes care of the job.
In Quarto, the responsibility for managing captions lies with the Quarto
framework itself. Consequently, the \code{set_caption()} function in 'flextable'
is not as useful in a 'Quarto' document. The formatting and numbering of
captions are determined by Quarto rather than flextable. Please refer to
the Quarto documentation for more information on how to work with captions
in Quarto.
}

\examples{
ftab <- flextable( head( iris ) )
ftab <- set_caption(ftab, "my caption")
ftab

library(officer)
autonum <- run_autonum(seq_id = "tab", bkm = "mtcars")
ftab <- flextable( head( mtcars ) )
ftab <- set_caption(ftab, caption = "mtcars data", autonum = autonum)
ftab
}
\seealso{
\code{\link[=flextable]{flextable()}}
}
