% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot.flimo_result}
\alias{plot.flimo_result}
\title{plot.flimo_result}
\usage{
\method{plot}{flimo_result}(
  x,
  y,
  ...,
  hist = FALSE,
  bins = 1 + as.integer(nrow(x$minimizer)^(1/3)),
  par_minimum = FALSE,
  pairwise_par = FALSE,
  boxplot = TRUE,
  par_names = NULL
)
}
\arguments{
\item{x}{Object of class flimo_result.}

\item{y}{unused generic argument.}

\item{...}{optional args for generic method}

\item{hist}{Boolean. If True, plots the histogram of each infered parameter. Default to false.}

\item{bins}{Integer. Number of bins if hist is True.}

\item{par_minimum}{Boolean. If True, plots each infered parameter by reached minimum. Default to false.}

\item{pairwise_par}{Boolean. If True, plots each pairs of infered parameters. Default to false.}

\item{boxplot}{Boolean. If True, plots the boxplots of each infered parameter scaled by their mean. Default to true.}

\item{par_names}{Vector of names for parameters. Default is "par1", ..., "parn".}
}
\value{
Nothing. Prints the asked ggplot objects.
}
\description{
Shows the plots for most important inference results. Default only shows normalized boxplots for each infered parameter.
}
