% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.r
\docType{methods}
\name{converters}
\alias{as.matrix.float32}
\alias{as.vector.float32}
\alias{converters}
\alias{dbl}
\alias{fl}
\alias{int}
\alias{storage.mode,float32-method}
\alias{typeof,float32-method}
\title{converters}
\usage{
fl(x, strict = FALSE)

dbl(x, strict = FALSE)

int(x, strict = FALSE)

\method{as.vector}{float32}(x, mode = "any")

\method{as.matrix}{float32}(x, ...)

\S4method{typeof}{float32}(x)

\S4method{storage.mode}{float32}(x)
}
\arguments{
\item{x}{A numeric or float vector/matrix.}

\item{strict}{Should the function error if given the wrong kind of input? Otherwise it just
silently returns the input.}

\item{mode, ...}{Ignored.}
}
\value{
The data stored in the type of whatever was asked for (the opposite of the
input).
}
\description{
Convert between a numeric vector/matrix and a float vector/matrix.
}
\examples{
library(float)

x = matrix(1:30, 10, 3)
s = fl(x)

y = dbl(s)

all.equal(x, y)

}

