% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggest.names.R
\name{suggest.names}
\alias{suggest.names}
\title{Suggest a valid name from a misspelled one}
\usage{
suggest.names(taxon, max.distance = 0.75, return.na = TRUE,
  ignore.words = NULL)
}
\arguments{
\item{taxon}{a character vector containing a single name}

\item{max.distance}{a numeric value indicating how conservative the function 
should be when searching for suggestions. Values close to 1 are very 
conservative}

\item{return.na}{a logical indicating whether to return a \code{NA} or the original 
input when no suggestion is found}

\item{ignore.words}{\code{NULL} or a character vector with words to be ignored by the function. 
Useful if you are automatizing a workflow and wants the function to ignore
words or phrases such as "not found", "dead", "undetermined", and so on}
}
\value{
A character vector or \code{NA}
}
\description{
This function tries to suggest a valid name according to the Brazilian Flora
Checklist using a possibly incorrect one as a starting point.
}
\examples{
\dontrun{
suggest.names("Cofea arabyca")
suggest.names("Myrcia bela")
}
}
