% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_flow_debug.R
\name{flow_debug}
\alias{flow_debug}
\alias{flow_debugonce}
\alias{flow_undebug}
\title{Debug With Flow Diagrams}
\usage{
flow_debug(
  f,
  prefix = NULL,
  code = TRUE,
  narrow = FALSE,
  truncate = NULL,
  swap = TRUE,
  out = NULL,
  browse = FALSE
)

flow_debugonce(
  f,
  prefix = NULL,
  code = TRUE,
  narrow = FALSE,
  truncate = NULL,
  swap = TRUE,
  out = NULL,
  browse = FALSE
)

flow_undebug(f)
}
\arguments{
\item{f}{function to debug}

\item{prefix}{prefix to use for special comments in our code used as block headers,
must start with \code{"#"}, several prefixes can be provided}

\item{code}{Whether to display the code in code blocks or only the header,
to be more compact, if \code{NA}, the code will be displayed only if no header
is defined by special comments}

\item{narrow}{\code{TRUE} makes sure the diagram stays centered on one column
(they'll be longer but won't shift to the right)}

\item{truncate}{maximum number of characters to be printed per line}

\item{swap}{whether to change \code{var <- if(cond) expr} into
\code{if(cond) var <- expr} so the diagram displays better}

\item{out}{a path to save the diagram to.
Special values "html", "htm", "png", "pdf", "jpg" and "jpeg" can be used to
export the object to a temp file of the relevant format and open it,
if a regular path is used the format will be guessed from the extension.}

\item{browse}{whether to debug step by step (block by block),
can also be a vector of block ids, in this case \code{browser()} calls will be
inserted at the start of these blocks}
}
\value{
These functions return \code{NULL} invisibly (called for side effects)
}
\description{
These functions are named after the base functions \code{debug()}, \code{undebug()} and
\code{debugonce()}. \code{flow_debug()} will call \code{flow_run()}, with the same additional arguments, on all the following
calls to \code{f()} until \code{flow_undebug()} is called. \code{flow_debugonce()} will only
call \code{flow_run()} on the next call to \code{f()}.
}
\details{
By default, unlike \code{debug()} and \code{debugonce()}, \code{flow_debug()} and
\code{flow_debugonce()} don't trigger a debugger but only draw diagrams, this is
consistent with \code{flow_run()}'s defaults. To browse through the code, use
the \code{browse} argument.
}
