% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/flows.R
\name{plotMapDomFlows}
\alias{plotMapDomFlows}
\title{Dominant Flows Map}
\usage{
plotMapDomFlows(mat, spdf, spdfid, w, wid, wvar, wcex = 0.05,
  legend.flows.pos = "topright", legend.flows.title = "flow intensity",
  legend.nodes.pos = "topleft", legend.node.txt = c("Dominant",
  "Intermediary", "Dominated", "Size proportional\\nto sum of inflows"),
  add = FALSE)
}
\arguments{
\item{mat}{A square matrix of dominant flows (see \link{domflows}).}

\item{spdf}{A SpatialPolygonsDataFrame or a SpatialPointsDataFrame of units.}

\item{spdfid}{Name of the unique identifier variable in the spdf data.frame.}

\item{w}{A data.frame which contains the weight variable used to plot units sizes on the map.}

\item{wid}{Name of the unique identifier variable in w.}

\item{wvar}{Name of the weight variable in w.}

\item{wcex}{Share of the surface of the map occupied by circles (0.02 is 2\%).}

\item{legend.flows.pos}{Position of the flows legend, one of "topleft", "top",
"topright", "left", "right", "bottomleft", "bottom", "bottomright".}

\item{legend.flows.title}{Title of the flows legend.}

\item{legend.nodes.pos}{Position of the nodes legend, one of "topleft", "top",
"topright", "left", "right", "bottomleft", "bottom", "bottomright".}

\item{legend.node.txt}{Text of the nodes legend.}

\item{add}{A boolean, if TRUE, add the layer to an existing plot.}
}
\description{
This function plots a dominant flows map.
}
\examples{
# Import data
data(nav)
myflows <- prepflows(mat = nav, i = "i", j = "j", fij = "fij")

# Remove the matrix diagonal
diag(myflows) <- 0

# Select the dominant flows (incoming flows criterion)
flowSel1 <- domflows(mat = myflows, wi = colSums(myflows), wj = rowSums(myflows),
                     k = 1)
# Select the first flows
flowSel2 <- firstflows(mat = myflows, method = "nfirst", ties.method = "first",
                       k = 1)

# Combine selections
flowSel <- myflows * flowSel1 * flowSel2

# Node weights
inflows <- data.frame(id = colnames(myflows), w = colSums(myflows))

# Plot dominant flows map
opar <- par(mar = c(0,0,2,0))
sp::plot(GE, col = "#cceae7", border = NA)
plotMapDomFlows(mat = flowSel, spdf = UA, spdfid = "ID", w = inflows, wid = "id",
                wvar = "w", wcex = 0.05, add = TRUE,
                legend.flows.pos = "bottomleft",
                legend.flows.title = "Nb. of commuters")
title("Dominant Flows of Commuters")
mtext(text = "INSEE, 2011", side = 4, line = -1, adj = 0.01, cex = 0.8)
par(opar)
}
\seealso{
\link{domflows}, \link{plotDomFlows}
}

