% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows.R
\name{firstflows}
\alias{firstflows}
\title{Flow Selection from Origins}
\usage{
firstflows(mat, method = "nfirst", ties.method = "first", k)
}
\arguments{
\item{mat}{A square matrix of flows.}

\item{method}{A method of flow selection, one of "nfirst", "xfirst" or "xsumfirst":
\itemize{
\item{nfirst selects the k first flows from origins,}
\item{xfirst selects flows greater than k,}
\item{xsumfirst selects as many flows as necessary for each origin so that their sum is at least equal to k.
If k is not reached for one origin, all its flows are selected.}
}}

\item{ties.method}{In case of equality with "nfirst" method, use "random" or "first" (see \link{rank}).}

\item{k}{Selection threshold.}
}
\value{
A boolean matrix of selected flows.
}
\description{
Flow selection from origins.
}
\details{
As the output is a boolean matrix, use element-wise multiplication to get flows intensity.
}
\examples{
# Import data
data(nav)
myflows <- prepflows(mat = nav, i = "i", j = "j", fij = "fij")

# Remove the matrix diagonal
diag(myflows) <- 0

# Select the 2 first flows of each origin
flowSel <- firstflows(mat = myflows, method = "nfirst", ties.method = "first",
                      k = 2)
statmat(mat = myflows * flowSel, output = "none")

# Select flows greater than 2000
flowSel <- firstflows(mat = myflows, method = "xfirst", k = 2000)
statmat(mat = myflows * flowSel, output = "none")

# Select as many flows as necessary for each origin so that their sum is at
# least equal to 20000
flowSel <- firstflows(myflows, method = "xsumfirst", k = 20000)
statmat(mat = myflows * flowSel, output = "none")

# Select each flows that represent at least 10\% of the outputs
myflowspct <- myflows / rowSums(myflows) * 100
flowSel <- firstflows(mat = myflowspct, method = "xfirst", k = 10)
statmat(mat = myflows * flowSel, output = "none")
}
\seealso{
\link{firstflowsg}, \link{domflows}
}

