% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_rda.R
\name{import_rda}
\alias{import_rda}
\title{Read RDA file}
\usage{
import_rda(file, FUN = load, data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source), envir = globalenv(),
  dir = flyio_get_dir(), delete_file = TRUE, ...)
}
\arguments{
\item{file}{path of the file to be read}

\item{FUN}{the function using which the file is to be read}

\item{data_source}{the name of the data source, if not set globally. s3, gcs or local}

\item{bucket}{the name of the bucket, if not set globally}

\item{envir}{the environment in which to import the objects}

\item{dir}{the directory to store intermediate files}

\item{delete_file}{logical. to delete the file downloaded}

\item{...}{other parameters for the FUN function defined above}
}
\value{
the output of the FUN function
}
\description{
Read RData or rda file from anywhere
}
\examples{
\dontrun{
# Load RDA from Google Cloud
flyio_set_datasource("gcs")
flyio_set_bucket("your-bucket-name")
import_rda("rds-on-cloud.rda", dir = tempdir())
}
}
