% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interest-rate-classes.R
\name{is_valid_compounding}
\alias{is_valid_compounding}
\alias{compounding}
\title{Compounding frequencies}
\usage{
is_valid_compounding(compounding)
}
\arguments{
\item{compounding}{a numeric vector representing the compounding frequency}
}
\value{
a flag (\code{TRUE} or \code{FALSE}) if all the supplied compounding
frequencies are supported.
}
\description{
A non-exported function that checks whether compounding values frequencies
are supported.
}
\details{
Valid compounding values are:
\tabular{ll}{
\bold{Value}  \tab \bold{Frequency}  \cr
-1            \tab Simply, T-bill discounting    \cr
0             \tab Simply                        \cr
1             \tab Annually                      \cr
2             \tab Semi-annually                 \cr
3             \tab Tri-annually                  \cr
4             \tab Quarterly                     \cr
6             \tab Bi-monthly                    \cr
12            \tab Monthly                       \cr
24            \tab Fortnightly                   \cr
52            \tab Weekly                        \cr
365           \tab Daily                         \cr
Inf           \tab Continuously                  \cr
}
}
