% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{fm_list}
\alias{fm_list}
\alias{fm_as_list}
\alias{c.fm_list}
\alias{[.fm_list}
\title{Handle lists of fmesher objects}
\usage{
fm_list(x, ..., .class_stub = NULL)

fm_as_list(x, ..., .class_stub = NULL)

\method{c}{fm_list}(...)

\method{[}{fm_list}(x, i)
}
\arguments{
\item{x}{\code{fm_list} object from which to extract element(s)}

\item{...}{Arguments passed to each individual conversion call.}

\item{.class_stub}{character; class stub name of class to convert each list
element to. If \code{NULL}, uses \code{fm_as_fm} and auto-detects if the resulting
list has consistent class, and then adds that to the class list.  If
non-null, uses \code{paste0("fm_as_", .class_stub)} for conversion, and verifies
that the resulting list has elements consistent with that class.}

\item{i}{indices specifying elements to extract}
}
\value{
An \code{fm_list} object, potentially with \verb{fm_\{class_stub\}_list}
added.
}
\description{
Methods for constructing and manipulating \code{fm_list} objects.
}
\section{Methods (by generic)}{
\itemize{
\item \code{c(fm_list)}: The \code{...} arguments should be coercible to \code{fm_list}
objects.

\item \code{[}: Extract sub-list

}}
\section{Functions}{
\itemize{
\item \code{fm_list()}: Convert each element of a list, or convert a single
non-list object and return in a list

\item \code{fm_as_list()}: Convert each element of a list, or convert a single
non-list object and return in a list

}}
\examples{
fm_as_list(list(fmexample$mesh, fm_segm_join(fmexample$boundary_fm)))

}
