% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callerFunctions.R
\name{callCalcExactIntegralC}
\alias{callCalcExactIntegralC}
\title{Analytically normalizes density to one}
\usage{
callCalcExactIntegralC(X, y, cvh, filter, eps)
}
\arguments{
\item{X}{Set of data points (one sample per row)}

\item{y}{Vector of function evaluations log(f(X_i))}

\item{cvh}{Matrix where each row is a set of indices of points in X
describing one face of conv(X)}

\item{filter}{Vector of with entries TRUE/FALSE indicating
which data points to discard (indicated by FALSE)}

\item{eps}{The maximum integration error allowed}
}
\value{
List containing the normalized parametrers
  \item{a}{Vector of hyperplane slopes}
  \item{b}{Vector of hyperplane offsets}
}
\description{
\code{callCalcExactIntegralC} is a wrapper to a C function that
  analytically normalizes a log-concave density, uniquely described by X and y,
  where y_i = log(f(X_i)), by adapting the function values y uniformly by some delta.
}
