% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osar.r
\name{osar}
\alias{osar}
\title{calculate one-step-ahead (prediction) residuals from a \code{foieGras} fit}
\usage{
osar(x, method = "fullGaussian", ...)
}
\arguments{
\item{x}{a compound \code{fG} tbl fit object}

\item{method}{method to calculate prediction residuals (default is "oneStepGaussianOffMode"; see \code{?TMB::oneStepPrediction} for details)}

\item{...}{other arguments to TMB::oneStepPrediction}
}
\description{
calculate one-step-ahead (prediction) residuals from a \code{foieGras} fit
}
\details{
One-step-ahead residuals are useful for assessing goodness-of-fit in latent variable models. This is a wrapper function for TMB::oneStepPredict (beta version). \code{osar} tries the "fullGaussian" (fastest) method first and falls back to the "oneStepGaussianOffMode" (slower) method for any failures. Subsequent failures are dropped from the output and a warning message is given. Note, OSA residuals can take a considerable time to calculate if there are many individual fits and/or deployments are long. The method is automatically parallelized across 2 x the number of individual fits, up to the number of processor cores available.
}
\examples{
## see summary fit output
## load example foieGras fit object (to save time)
data(xs)
d <- xs[1, ] ## just use the first seal to save time
dres <- osar(d)

}
\references{
Thygesen, U. H., C. M. Albertsen, C. W. Berg, K. Kristensen, and A. Neilsen. 2017. Validation of ecological state space models using the Laplace approximation. Environmental and Ecological Statistics 24:317–339.
}
