% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{accuracy}
\alias{accuracy}
\alias{accuracy.default}
\title{Accuracy measures for a forecast model}
\usage{
accuracy(object, ...)

\method{accuracy}{default}(object, x, test = NULL, d = NULL, D = NULL, f = NULL, ...)
}
\arguments{
\item{object}{An object of class \dQuote{\code{forecast}}, or a numerical vector
containing forecasts. It will also work with \code{Arima}, \code{ets} and
\code{lm} objects if \code{x} is omitted -- in which case training set accuracy
measures are returned.}

\item{...}{Additional arguments depending on the specific method.}

\item{x}{An optional numerical vector containing actual values of the same
length as object, or a time series overlapping with the times of \code{f}.}

\item{test}{Indicator of which elements of \code{x} and \code{f} to test. If
\code{test} is \code{NULL}, all elements are used. Otherwise test is a
numeric vector containing the indices of the elements to use in the test.}

\item{d}{An integer indicating the number of lag-1 differences to be used
for the denominator in MASE calculation. Default value is 1 for non-seasonal
series and 0 for seasonal series.}

\item{D}{An integer indicating the number of seasonal differences to be used
for the denominator in MASE calculation. Default value is 0 for non-seasonal
series and 1 for seasonal series.}

\item{f}{Deprecated. Please use `object` instead.}
}
\value{
Matrix giving forecast accuracy measures.
}
\description{
Returns range of summary measures of the forecast accuracy. If \code{x} is
provided, the function measures test set forecast accuracy
based on \code{x-f}. If \code{x} is not provided, the function only produces
training set accuracy measures of the forecasts based on
\code{f["x"]-fitted(f)}. All measures are defined and discussed in Hyndman
and Koehler (2006).
}
\details{
The measures calculated are:
\itemize{
  \item ME: Mean Error
  \item RMSE: Root Mean Squared Error
  \item MAE: Mean Absolute Error
  \item MPE: Mean Percentage Error
  \item MAPE: Mean Absolute Percentage Error
  \item MASE: Mean Absolute Scaled Error
  \item ACF1: Autocorrelation of errors at lag 1.
}
By default, the MASE calculation is scaled using MAE of training set naive
forecasts for non-seasonal time series, training set seasonal naive forecasts
for seasonal time series and training set mean forecasts for non-time series data.
If \code{f} is a numerical vector rather than a \code{forecast} object, the MASE
will not be returned as the training data will not be available.

See Hyndman and Koehler (2006) and Hyndman and Athanasopoulos (2014, Section
2.5) for further details.
}
\examples{

fit1 <- rwf(EuStockMarkets[1:200, 1], h = 100)
fit2 <- meanf(EuStockMarkets[1:200, 1], h = 100)
accuracy(fit1)
accuracy(fit2)
accuracy(fit1, EuStockMarkets[201:300, 1])
accuracy(fit2, EuStockMarkets[201:300, 1])
plot(fit1)
lines(EuStockMarkets[1:300, 1])
}
\references{
Hyndman, R.J. and Koehler, A.B. (2006) "Another look at measures
of forecast accuracy". \emph{International Journal of Forecasting},
\bold{22}(4), 679-688. Hyndman, R.J. and Athanasopoulos, G. (2018)
"Forecasting: principles and practice", 2nd ed., OTexts, Melbourne, Australia.
Section 3.4 "Evaluating forecast accuracy".
\url{https://otexts.org/fpp2/accuracy.html}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
