% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastSNSTS-package.R
\docType{package}
\name{forecastSNSTS-package}
\alias{forecastSNSTS}
\alias{forecastSNSTS-package}
\title{Forecasting of Stationary and Non-Stationary Time Series}
\description{
Methods to compute linear \eqn{h}-step ahead prediction coefficients based
on localised and iterated Yule-Walker estimates and empirical mean squared
prediction errors for the resulting predictors. Also, functions to compute
autocovariances for AR(p) processes, to simulate tvARMA(p,q) time series,
and to verify an assumption from Kley et al. (2017).
}
\details{
\tabular{ll}{
   \cr Package: \tab forecastSNSTS
   \cr Type:    \tab Package
   \cr Version: \tab 1.1-1
   \cr Date:    \tab 2017-01-19
   \cr License: \tab GPL (>= 2)
 }
}
\section{Contents}{

The core functionality of this R package is accessable via the function
\code{\link{predCoef}}, which is used to compute the linear prediction
coefficients, and the function \code{\link{MSPE}}, which is used to compute
the empirical mean squared prediciton erros. Further, the function
\code{\link{f}} can be used to verify condition (10) of Theorem 3.1 in
Kley et al (2017) for any given tvAR(p) model.
The function \code{\link{tvARMA}} can be used to simulate time-varying
ARMA(p,q) time series.
The function \code{\link{acfARp}} computes the autocovariances of a AR(p)
process from the coefficients and innovations standard deviation.
}
\author{
Tobias Kley
}
\references{
Kley, T., Preuss, P. & Fryzlewicz, P. (2017).
Predictive, finite-sample model choice for time series under stationarity
and non-stationarity.
[cf. \url{https://arxiv.org/abs/1611.04460}]
}

