% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realized_productivity.R
\name{realized.productivity}
\alias{realized.productivity}
\title{Calculate the realized productivity.}
\usage{
realized.productivity(forestData, left = 0.05, right = 100)
}
\arguments{
\item{forestData}{A forestData class data}

\item{left}{Solving for the left boundary of the realized productivity.}

\item{right}{Solving for the right boundary of the realized productivity.}
}
\value{
A forestData class in which a data.frame with realized productivity parameters is added.
}
\description{
realized.productivity calculate the realized productivity of each stand based on model parameters (obtained from the parameterOutput function).
}
\details{
realized.productivity takes data,data_BA,data_V parameters as required inputs.
}
\examples{
\donttest{
# Load sample data
data("forestData")

# Build a model based on the forestData and return a forestData class object
forestData <- class.plot(forestData,model="Richards",
                         interval=5,number=5,maxiter=1000,
                         H_start=c(a=20,b=0.05,c=1.0))

# Calculate the realized productivity of the forestData object
forestData <- realized.productivity(forestData,left=0.05,right=100)
}
}
