% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_dyn.R
\name{forest_dyn}
\alias{forest_dyn}
\title{forest_dyn}
\usage{
forest_dyn(forest_df, inv_time, coord, add_wd = NULL)
}
\arguments{
\item{forest_df}{A dataframe containing the forest plot data, with columns for species name (spp),
and two DBH (Diameter at breast height) values (DBH_1 and DBH_2).}

\item{inv_time}{The number of years between the two forest measurements (time interval between observations).}

\item{coord}{A vector of geographic coordinates (longitude and latitude) for biomass calculation.}

\item{add_wd}{Additional wood density data that can be provided for species not included in the database.}
}
\value{
A list containing the forest community dynamics, with abundance metrics, dynamic rates,
        basal area, and biomass by year.
}
\description{
Function to calculate forest dynamics, including abundance, mortality and recruitment rates,
basal area, and biomass. The function uses diameter at breast height (DBH) data to estimate forest dynamics over time.
}
\examples{
forest_df <- data(forest_df_example)
coord <- c(-50.17,-27.71)
dyn_object <- forest_dyn(forest_df, inv_time = 5, coord = coord)

}
