% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_to_0.R
\name{na_to_0}
\alias{na_to_0}
\title{Convert NA to zero on numeric variables}
\usage{
na_to_0(df)
}
\arguments{
\item{df}{A data frame}
}
\value{
a data frame
}
\description{
This function Convert NA to zero on numeric variables outside of mutate.
this is used because of dplyr 1.1.0.
}
\examples{
library(forestmangr)
data("exfm15")
head(exfm15)

# Raise a numeric vector to the power of 2:
pow(iris$Petal.Length, 2)

# Fit a model that contains the dbh squared, without the need to create a new variable:
exfm15 \%>\% na_to_0()

}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
