% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpf_exporters.R
\name{mpf_to_rtf}
\alias{mpf_to_rtf}
\title{Transform MPF to RTF}
\usage{
mpf_to_rtf(
  mpf,
  colwidths = NULL,
  page_type = "letter",
  pg_width = page_dim(page_type)[if (landscape) 2 else 1],
  pg_height = page_dim(page_type)[if (landscape) 1 else 2],
  landscape = FALSE,
  margins = c(4, 4, 4, 4),
  font_size = 8,
  ...
)
}
\arguments{
\item{mpf}{MatrixPrintForm. MatrixPrintForm object.}

\item{colwidths}{character(1). Column widths.}

\item{page_type}{character(1).   Name   of  a  page  type.   See
\code{page_types}.   Ignored when  \code{pg_width} and  \code{pg_height}
are set directly.}

\item{pg_width}{numeric(1). Page width in inches.}

\item{pg_height}{numeric(1). Page height in inches.}

\item{landscape}{logical(1). Should the  dimensions of \code{page_type}
be inverted  for landscape?  Defaults to  \code{FALSE}, ignored when
\code{pg_width} and \code{pg_height} are set directly.}

\item{margins}{numeric(4). Named numeric vector containing \code{'top'},
\code{'bottom'}, \code{'left'}, and \code{'right'} margins in inches. Defaults
to \code{.5} inches for both vertical margins and \code{.75} for both
horizontal margins.}

\item{font_size}{numeric(1). Font size, defaults to 12.}

\item{...}{Passed to individual methods.}
}
\value{
An rtf object
}
\description{
Experimental export to RTF via the \code{r2rtf} package
}
\details{
This function provides a low-level coercion of a
\verb{MatrixPrintForm object into text containing the corresponding table in }RTF`. Currently, no pagination is done at this level,
and should be done prior to calling this function, though that
may change in the future.
}
